/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.sequencer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.NonNull;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.sequencer.IdSequencer;
import org.eclipse.emf.ecore.EObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicClassMembers;

public class ReferenceIndexSequencer
extends IdSequencer.Number {
    final EFeaturePath c;
    final Comparator<Object> d;
    final Set<EFeaturePath> e;

    protected ReferenceIndexSequencer(@NonNull EFeaturePath eFeaturePath, @NonNull Set<EFeaturePath> set, Comparator<Object> comparator, int n) {
        super(n);
        if (eFeaturePath == null) {
            throw new NullPointerException("path");
        }
        if (set == null) {
            throw new NullPointerException("extraPaths");
        }
        this.c = eFeaturePath;
        this.d = comparator;
        this.e = set.isEmpty() ? Collections.singleton(eFeaturePath) : Sets.union(Collections.singleton(eFeaturePath), set);
    }

    public static ReferenceIndexSequencer build(@NonNull EFeaturePath eFeaturePath) {
        if (eFeaturePath == null) {
            throw new NullPointerException("path");
        }
        return new Builder(eFeaturePath).create();
    }

    public static ReferenceIndexSequencer build(@NonNull EFeaturePath eFeaturePath, int n) {
        if (eFeaturePath == null) {
            throw new NullPointerException("path");
        }
        return new Builder(eFeaturePath).offset(n).create();
    }

    public static Builder builder(@NonNull EFeaturePath eFeaturePath) {
        if (eFeaturePath == null) {
            throw new NullPointerException("path");
        }
        return new Builder(eFeaturePath);
    }

    @Override
    public Object getFactor(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            for (EObject eObject2 : this.b(this.c, eObject)) {
                Iterable<Object> iterable = this.a(this.a(this.c, eObject2), this.d);
                int n = Iterables.indexOf(iterable, (Predicate)Predicates.equalTo((Object)object));
                if (n < 0) continue;
                return n + this.getOffset();
            }
        }
        return null;
    }

    @Override
    public Set<EFeaturePath> getAffectedPaths() {
        return this.e;
    }

    Set<Object> a(EFeaturePath eFeaturePath, EObject eObject) {
        return (Set)eFeaturePath.getFirst().getReferences(eObject, null, LinkedHashSet::new);
    }

    Set<EObject> b(EFeaturePath eFeaturePath, EObject eObject) {
        return (Set)eFeaturePath.getLast().getInverseReferences(eObject, null, LinkedHashSet::new);
    }

    Iterable<Object> a(Set<Object> set, Comparator<Object> comparator) {
        if (comparator == null || set.size() < 2) {
            return set;
        }
        ArrayList arrayList = Lists.newArrayList(set);
        arrayList.sort(comparator);
        return arrayList;
    }

    @Keep
    @KeepPublicClassMembers
    public static class Builder {
        final EFeaturePath a;
        Set<EFeaturePath> b;
        Comparator<Object> c;
        int d;

        Builder(@NonNull EFeaturePath eFeaturePath) {
            if (eFeaturePath == null) {
                throw new NullPointerException("path");
            }
            this.a = eFeaturePath;
            this.b = Collections.emptySet();
        }

        public Builder extraPaths(EFeaturePath eFeaturePath) {
            if (this.b.isEmpty()) {
                this.b = new HashSet<EFeaturePath>();
            }
            this.b.add(eFeaturePath);
            return this;
        }

        public Builder comparator(Comparator<Object> comparator) {
            this.c = comparator;
            return this;
        }

        public Builder offset(int n) {
            this.d = n;
            return this;
        }

        public ReferenceIndexSequencer create() {
            return new ReferenceIndexSequencer(this.a, this.b, this.c, this.d);
        }
    }
}

