/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.sequencer;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.sequencer.IdSequencer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class PatternSequencer
implements IdSequencer {
    private final MessageFormat a = new MessageFormat("{0}");
    protected final IdSequencer sequencer;
    protected final Pattern pattern;
    protected final EAttribute attribute;

    public PatternSequencer(@NonNull EAttribute eAttribute, @NonNull IdSequencer idSequencer, @NonNull Pattern pattern) {
        if (eAttribute == null) {
            throw new NullPointerException("attribute");
        }
        if (idSequencer == null) {
            throw new NullPointerException("sequencer");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        this.attribute = eAttribute;
        this.sequencer = idSequencer;
        this.pattern = pattern;
    }

    @Override
    public Object getFactor(Object object) {
        String string = this.getObjectValue(object);
        if (string == null) {
            return null;
        }
        String string2 = this.sequencer.format(object);
        if (string2 != null) {
            return new Object[]{this.replaceSequence(string, string2)};
        }
        return new Object[]{string};
    }

    @Override
    public Format getFormat() {
        return this.a;
    }

    @Override
    public Set<EFeaturePath> getAffectedPaths() {
        return this.sequencer.getAffectedPaths();
    }

    protected String getObjectValue(Object object) {
        if (this.attribute.getEContainingClass().isInstance(object)) {
            Object object2 = ((EObject)object).eGet((EStructuralFeature)this.attribute);
            return EcoreUtil.convertToString((EDataType)this.attribute.getEAttributeType(), (Object)object2);
        }
        return null;
    }

    protected String replaceSequence(String string, String string2) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = matcher.groupCount(); i > 0; --i) {
            stringBuilder.replace(matcher.start(i), matcher.end(i), string2);
        }
        return stringBuilder.toString();
    }
}

