/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.sequencer;

import com.google.common.base.Preconditions;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.sequencer.IdSequencer;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class IdSequencerFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private MessageFormat format;
    private Object[] arguments;
    private final EClass eClass;
    private final EAttribute attribute;
    private final EMap<EFeaturePath, IdSequencer> sequencers;

    protected IdSequencerFormat(MessageFormat messageFormat, EClass eClass, EAttribute eAttribute, EMap<EFeaturePath, IdSequencer> eMap) {
        this.format = messageFormat;
        this.arguments = new Object[eMap.size()];
        this.eClass = eClass;
        this.attribute = eAttribute;
        this.sequencers = eMap;
    }

    public static IdSequencerFormat build(String string, EClass eClass, EAttribute eAttribute, IdSequencer idSequencer) {
        return IdSequencerFormat.builder(string, eClass, eAttribute, idSequencer).create();
    }

    public static Builder builder(String string, EClass eClass, EAttribute eAttribute, IdSequencer idSequencer) {
        return new Builder(string, eClass, eAttribute, idSequencer);
    }

    public Set<EFeaturePath> getPaths() {
        return this.sequencers.keySet();
    }

    public IdSequencer getSequencer() {
        return (IdSequencer)((Map.Entry)this.sequencers.get(0)).getValue();
    }

    public IdSequencer getSequencer(EFeaturePath eFeaturePath) {
        return (IdSequencer)this.sequencers.get((Object)eFeaturePath);
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public EAttribute getAttribute() {
        return this.attribute;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n = 0;
        for (Map.Entry entry : this.sequencers) {
            EFeaturePath eFeaturePath = n > 0 ? (EFeaturePath)entry.getKey() : null;
            IdSequencer idSequencer = (IdSequencer)entry.getValue();
            this.arguments[n++] = this.getFactor(object, eFeaturePath, idSequencer);
        }
        return this.format.format(this.arguments, stringBuffer, fieldPosition);
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IdSequencerFormat clone() {
        IdSequencerFormat idSequencerFormat = (IdSequencerFormat)super.clone();
        idSequencerFormat.format = (MessageFormat)this.format.clone();
        idSequencerFormat.arguments = (Object[])this.arguments.clone();
        return idSequencerFormat;
    }

    protected Object getFactor(Object object, EFeaturePath eFeaturePath, IdSequencer idSequencer) {
        EObject eObject;
        Iterator iterator;
        if (eFeaturePath == null) {
            return idSequencer.getFactor(object);
        }
        if (object instanceof EObject && (iterator = eFeaturePath.getReferences(eObject = (EObject)object, eFeaturePath.getLast()).iterator()).hasNext()) {
            Object e = iterator.next();
            return idSequencer.getFactor(e);
        }
        return null;
    }

    public static class Builder {
        protected final EClass eClass;
        protected final EAttribute attribute;
        protected final MessageFormat format;
        protected final EMap<EFeaturePath, IdSequencer> sequencers = new BasicEMap();

        protected Builder(@NonNull String string, @NonNull EClass eClass, @NonNull EAttribute eAttribute, @NonNull IdSequencer idSequencer) {
            if (string == null) {
                throw new NullPointerException("pattern");
            }
            if (eClass == null) {
                throw new NullPointerException("eClass");
            }
            if (eAttribute == null) {
                throw new NullPointerException("attribute");
            }
            if (idSequencer == null) {
                throw new NullPointerException("sequencer");
            }
            EFeaturePath eFeaturePath = EFeaturePath.builder().add(eClass, (EStructuralFeature)eAttribute).create();
            this.format = new MessageFormat(string, Locale.ENGLISH);
            this.eClass = eClass;
            this.attribute = eAttribute;
            this.sequencers.put((Object)eFeaturePath, (Object)idSequencer);
        }

        public Builder addDependency(@NonNull EFeaturePath eFeaturePath, @NonNull IdSequencer idSequencer) {
            if (eFeaturePath == null) {
                throw new NullPointerException("path");
            }
            if (idSequencer == null) {
                throw new NullPointerException("sequencer");
            }
            Preconditions.checkArgument((eFeaturePath.getEClass() == this.eClass ? 1 : 0) != 0, (Object)"The class of path origin must be same as eClass");
            this.sequencers.put((Object)eFeaturePath, (Object)idSequencer);
            return this;
        }

        public IdSequencerFormat create() {
            int n = this.format.getFormatsByArgumentIndex().length;
            int n2 = Math.min(n, this.sequencers.size());
            for (int i = 0; i < n2; ++i) {
                IdSequencer idSequencer = (IdSequencer)((Map.Entry)this.sequencers.get(i)).getValue();
                this.format.setFormatByArgumentIndex(i, idSequencer.getFormat());
            }
            return new IdSequencerFormat(this.format, this.eClass, this.attribute, this.sequencers);
        }
    }
}

