/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing.editor;

import java.awt.Dimension;
import java.awt.event.MouseListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.astah.emf.edit.provider.swing.PropertyEditorFactory;
import net.astah.emf.edit.provider.swing.editor.EDataTypeCellEditor;
import net.astah.emf.edit.provider.swing.editor.b;
import net.astah.golf.draw.UndoableTextArea;
import net.astah.golf.view.swing.ElasticTextArea;
import net.astah.golf.view.swing.MultilineTextPropertyCellEditor;
import net.astah.golf.view.swing.PropertyCellEditor;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

public class MultilineCellEditor
extends EDataTypeCellEditor
implements MultilineTextPropertyCellEditor {
    private static final long serialVersionUID = 1L;
    private boolean stopEditingOnEnterKey;

    public MultilineCellEditor(final JTextArea jTextArea) {
        super(new JTextField());
        this.setFlexible(true);
        jTextArea.setFont(null);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea){

            @Override
            public void requestFocus() {
                this.getViewport().getView().requestFocus();
            }
        };
        jScrollPane.getViewport().setFont(null);
        this.editorComponent = jScrollPane;
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object object) {
                if (jTextArea instanceof UndoableTextArea) {
                    ((UndoableTextArea)jTextArea).setText(object != null ? object.toString() : "", false);
                } else {
                    jTextArea.setText(object != null ? object.toString() : "");
                }
            }

            @Override
            public Object getCellEditorValue() {
                return jTextArea.getText();
            }
        };
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        this.getTextArea().setMinimumSize(dimension);
    }

    public JTextArea getTextArea() {
        return (JTextArea)((JScrollPane)this.editorComponent).getViewport().getView();
    }

    public int getRows() {
        return this.getTextArea().getRows();
    }

    public void setRows(int n) {
        this.getTextArea().setRows(n);
    }

    public int getColumns() {
        return this.getTextArea().getColumns();
    }

    public void setColumns(int n) {
        this.getTextArea().setColumns(n);
    }

    @Override
    public void startCellEditing() {
        super.startCellEditing();
        this.getTextArea().selectAll();
    }

    public boolean isStopEditingOnEnterKey() {
        return this.stopEditingOnEnterKey;
    }

    public void setStopEditingOnEnterKey(boolean bl) {
        this.stopEditingOnEnterKey = bl;
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.getTextArea().addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.getTextArea().removeMouseListener(mouseListener);
    }

    public static class DescriptorImpl
    implements PropertyEditorFactory,
    PropertyEditorFactory.PredicateDescriptor {
        @Override
        public boolean evaluate(Object object, IItemPropertyDescriptor iItemPropertyDescriptor) {
            return iItemPropertyDescriptor.isMultiLine(object);
        }

        @Override
        public PropertyEditorFactory getFactory() {
            return this;
        }

        @Override
        public PropertyCellEditor createPropertyEditor(Object object, IItemPropertyDescriptor iItemPropertyDescriptor) {
            ElasticTextArea elasticTextArea = new ElasticTextArea();
            MultilineCellEditor multilineCellEditor = new MultilineCellEditor((JTextArea)elasticTextArea);
            elasticTextArea.addKeyListener(new b(this, (JTextArea)elasticTextArea, multilineCellEditor));
            multilineCellEditor.setEditingProperty(object, iItemPropertyDescriptor);
            return multilineCellEditor;
        }
    }
}

