/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import net.astah.emf.edit.Messages;
import net.astah.golf.view.swing.FlexiblePropertyCellEditor;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractFlexiblePropertyCellEditor
extends DefaultCellEditor
implements FlexiblePropertyCellEditor {
    private static final long serialVersionUID = 4129514461369331825L;
    private static final String a = "edit";
    protected Object object;
    protected IItemPropertyDescriptor propertyDescriptor;
    private boolean flexible = true;
    protected JButton trigger;

    public AbstractFlexiblePropertyCellEditor(JCheckBox jCheckBox) {
        super(jCheckBox);
    }

    public AbstractFlexiblePropertyCellEditor(JComboBox<?> jComboBox) {
        super(jComboBox);
    }

    public AbstractFlexiblePropertyCellEditor(JTextField jTextField) {
        super(jTextField);
    }

    protected AbstractFlexiblePropertyCellEditor() {
        super(new JTextField());
        this.editorComponent = null;
        this.delegate = null;
    }

    public void setCellEditorValue(Object object) {
        this.delegate.setValue(object);
        if (this.trigger != null) {
            this.trigger.setText(object instanceof String ? (String)object : "");
        }
    }

    public boolean isFlexible() {
        return this.flexible;
    }

    public void setFlexible(boolean bl) {
        this.flexible = bl;
    }

    public Dimension getPreferredSize() {
        return this.getComponent().getPreferredSize();
    }

    public void setPreferredSize(Dimension dimension) {
        this.getComponent().setPreferredSize(dimension);
    }

    public void setMinimumSize(Dimension dimension) {
        this.getComponent().setMinimumSize(dimension);
    }

    public void setMaximumSize(Dimension dimension) {
        this.getComponent().setMaximumSize(dimension);
    }

    public void setSize(Dimension dimension) {
        this.getComponent().setSize(dimension);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        throw new UnsupportedOperationException();
    }

    public Component getPropertyCellEditorComponent(Component component, Object object) {
        if (component instanceof CellEditorListener) {
            this.addCellEditorListener((CellEditorListener)((Object)component));
        }
        if (this.isFlexible()) {
            if (this.trigger != null) {
                this.trigger = null;
            }
            this.setCellEditorValue(object);
            return this.getComponent();
        }
        if (this.trigger == null) {
            this.trigger = this.createTrigger();
        }
        this.trigger.setFont(component.getFont());
        this.setCellEditorValue(object);
        return this.trigger;
    }

    protected JButton createTrigger() {
        JButton jButton = new JButton();
        jButton.setBackground(Color.WHITE);
        jButton.setActionCommand(a);
        jButton.addActionListener(actionEvent -> {
            Object object = actionEvent.getSource();
            if (a.equals(actionEvent.getActionCommand()) && object instanceof Component) {
                this.editInDialog((Component)object);
            }
        });
        jButton.setBorderPainted(true);
        jButton.setHorizontalAlignment(10);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    protected void editInDialog(Component component) {
        this.getComponent().setFont(component.getFont());
        if (this.showInputDialog(component) == 0) {
            this.fireEditingStopped();
        } else {
            this.fireEditingCanceled();
        }
    }

    protected int showInputDialog(Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.getComponent(), "Center");
        GridLayout gridLayout = new GridLayout();
        gridLayout.setHgap(5);
        JPanel jPanel2 = new JPanel(gridLayout);
        jPanel2.add(jPanel);
        jPanel2.addHierarchyListener(hierarchyEvent -> {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(jPanel2);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        });
        String string = this.propertyDescriptor.getDisplayName(this.object);
        return JOptionPane.showConfirmDialog(component, jPanel2, NLS.bind((String)Messages.EDataTypeCellEditor_dialogTile, (Object)string), 2, -1);
    }

    protected void setEditingProperty(Object object, IItemPropertyDescriptor iItemPropertyDescriptor) {
        this.object = object;
        this.propertyDescriptor = iItemPropertyDescriptor;
    }
}

