/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.awt.Component;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.JTree;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.LabelProviderTreeCellRenderer;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalLabelProviderTreeCellRenderer
extends LabelProviderTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Logger a = LoggerFactory.getLogger(TransactionalLabelProviderTreeCellRenderer.class);
    protected final TransactionalEditingDomain domain;

    public TransactionalLabelProviderTreeCellRenderer(TransactionalEditingDomain transactionalEditingDomain, ILabelProvider iLabelProvider) {
        super(iLabelProvider);
        this.domain = Objects.requireNonNull(transactionalEditingDomain, "domain");
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        FutureTask<Component> futureTask = new FutureTask<Component>(() -> this.doGetTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4));
        try {
            this.domain.runExclusive(futureTask);
            return futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            a.debug("Interrupted", (Throwable)interruptedException);
            return this;
        }
        catch (ExecutionException executionException) {
            a.warn("Failed to renderer component for " + object, (Throwable)executionException);
            return this;
        }
    }

    protected Component doGetTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }
}

