/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import net.astah.emf.common.transaction.Transactions;
import net.astah.emf.edit.provider.swing.ContentProviderTreeModel;
import net.astah.golf.widget.swing.ITreeContentProvider;
import net.astah.jomt.jutil.SwingInvoker;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalContentProviderTreeModel
extends ContentProviderTreeModel
implements Executor {
    private static final Logger a = LoggerFactory.getLogger(TransactionalContentProviderTreeModel.class);
    protected final TransactionalEditingDomain domain;

    public TransactionalContentProviderTreeModel(TransactionalEditingDomain transactionalEditingDomain, ITreeContentProvider iTreeContentProvider) {
        super(iTreeContentProvider);
        this.domain = Objects.requireNonNull(transactionalEditingDomain, "domain");
    }

    @Override
    public Object getParent(Object object) {
        return this.a(() -> this.doGetParent(object), null, "get parent of {0}", object);
    }

    @Override
    public Object[] getPathToRoot(Object object) {
        return this.a(() -> this.doGetPathToRoot(object), null, "get path to root of {0}", object);
    }

    @Override
    protected Collection<?> getChildren(Object object) {
        return this.a(() -> this.doGetChildren(object), Collections.emptyList(), "get children of {0}", object);
    }

    protected Object doGetParent(Object object) {
        return super.getParent(object);
    }

    protected Object[] doGetPathToRoot(Object object) {
        return super.getPathToRoot(object);
    }

    protected Collection<?> doGetChildren(Object object) {
        return super.getChildren(object);
    }

    @Override
    public void execute(Runnable runnable) {
        SwingInvoker.runLaterInEDT(() -> {
            try {
                Transactions.safeRunExclusive((TransactionalEditingDomain)this.domain, (Runnable)runnable).get();
            }
            catch (ExecutionException executionException) {
                a.error("Failed to execute task", executionException.getCause());
            }
            catch (InterruptedException | CancellationException exception) {
                a.info("The task has been canceled: {}", (Object)runnable);
            }
        });
    }

    <V> V a(Callable<V> callable, V v, String string, Object ... objectArray) {
        try {
            return Transactions.safeRunExclusive((TransactionalEditingDomain)this.domain, callable).get();
        }
        catch (InterruptedException interruptedException) {
            a.debug("Interrupted", (Throwable)interruptedException);
            return v;
        }
        catch (CancellationException cancellationException) {
            a.debug("Cancelled: " + MessageFormat.format(string, objectArray), (Throwable)cancellationException);
            return v;
        }
        catch (ExecutionException executionException) {
            a.warn("Failed: " + MessageFormat.format(string, objectArray), executionException.getCause());
            return v;
        }
    }
}

