/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import net.astah.emf.common.transaction.Transactions;
import net.astah.emf.edit.provider.swing.ContentProviderTableModel;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.widget.swing.IStructuredContentProvider;
import net.astah.jomt.jutil.SwingInvoker;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalContentProviderTableModel
extends ContentProviderTableModel
implements Executor {
    private static final Logger b = LoggerFactory.getLogger(TransactionalContentProviderTableModel.class);
    protected final TransactionalEditingDomain domain;

    public TransactionalContentProviderTableModel(TransactionalEditingDomain transactionalEditingDomain, IStructuredContentProvider iStructuredContentProvider, IPropertySourceProvider iPropertySourceProvider, ITableColumnProvider iTableColumnProvider) {
        super(iStructuredContentProvider, iPropertySourceProvider, iTableColumnProvider);
        this.domain = Objects.requireNonNull(transactionalEditingDomain, "domain");
    }

    public TransactionalContentProviderTableModel(TransactionalEditingDomain transactionalEditingDomain, IStructuredContentProvider iStructuredContentProvider, ITableColumnProvider iTableColumnProvider) {
        this(transactionalEditingDomain, iStructuredContentProvider, (IPropertySourceProvider)iStructuredContentProvider, iTableColumnProvider);
    }

    @Override
    public int getRowCount() {
        return this.a(() -> this.doGetRowCount(), 0, "get row count", new Object[0]);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.a(() -> this.doGetValueAt(n, n2), null, "get value at {0}:{1}", n, n2);
    }

    @Override
    public Object getRowAt(int n) {
        return this.a(() -> this.doGetRowAt(n), null, "row object at {0}", n);
    }

    @Override
    public int getIndexOfRow(Object object) {
        return this.a(() -> this.doGetIndexOfRow(object), -1, "row index of {0}", object);
    }

    protected int doGetRowCount() {
        return super.getRowCount();
    }

    protected Object doGetValueAt(int n, int n2) {
        return super.getValueAt(n, n2);
    }

    protected Object doGetRowAt(int n) {
        return super.getRowAt(n);
    }

    protected int doGetIndexOfRow(Object object) {
        return super.getIndexOfRow(object);
    }

    @Override
    public void execute(Runnable runnable) {
        SwingInvoker.runLaterInEDT(() -> {
            try {
                Transactions.safeRunExclusive((TransactionalEditingDomain)this.domain, (Runnable)runnable).get();
            }
            catch (ExecutionException executionException) {
                b.error("Failed to execute task", executionException.getCause());
            }
            catch (InterruptedException | CancellationException exception) {
                b.info("The task has been canceled: ", (Object)runnable);
            }
        });
    }

    <V> V a(Callable<V> callable, V v, String string, Object ... objectArray) {
        try {
            return Transactions.safeRunExclusive((TransactionalEditingDomain)this.domain, callable).get();
        }
        catch (InterruptedException interruptedException) {
            b.debug("Interrupted", (Throwable)interruptedException);
            return v;
        }
        catch (CancellationException cancellationException) {
            b.debug("Cancelled: " + MessageFormat.format(string, objectArray), (Throwable)cancellationException);
            return v;
        }
        catch (ExecutionException executionException) {
            b.warn("Failed: " + MessageFormat.format(string, objectArray), executionException.getCause());
            return v;
        }
    }
}

