/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import net.astah.emf.common.transaction.Transactions;
import net.astah.emf.edit.provider.swing.AdapterFactoryTreeCellEditor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalAdapterFactoryTreeCellEditor
extends AdapterFactoryTreeCellEditor {
    private static final Logger a = LoggerFactory.getLogger(TransactionalAdapterFactoryTreeCellEditor.class);
    protected final TransactionalEditingDomain domain;

    public TransactionalAdapterFactoryTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TransactionalEditingDomain transactionalEditingDomain, AdapterFactory adapterFactory) {
        super(jTree, defaultTreeCellRenderer, adapterFactory);
        this.domain = Objects.requireNonNull(transactionalEditingDomain, "domain");
    }

    public TransactionalAdapterFactoryTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TreeCellEditor treeCellEditor, TransactionalEditingDomain transactionalEditingDomain, AdapterFactory adapterFactory) {
        super(jTree, defaultTreeCellRenderer, treeCellEditor, adapterFactory);
        this.domain = Objects.requireNonNull(transactionalEditingDomain, "domain");
    }

    @Override
    protected Object getPropertyValue(IItemPropertyDescriptor iItemPropertyDescriptor, Object object) {
        return this.a(() -> this.doGetPropertyValue(iItemPropertyDescriptor, object), null, "get property value of {0}", object);
    }

    @Override
    protected void setPropertyValue(IItemPropertyDescriptor iItemPropertyDescriptor, Object object, Object object2) {
        if (Transactions.isWritable((TransactionalEditingDomain)this.domain)) {
            this.doSetPropertyValue(iItemPropertyDescriptor, object, object2);
        }
    }

    @Override
    protected boolean canSetProperty(IItemPropertyDescriptor iItemPropertyDescriptor, Object object) {
        return this.a(() -> this.doCanSetProperty(iItemPropertyDescriptor, object), false, "get whether property can set for {0}", object);
    }

    protected Object doGetPropertyValue(IItemPropertyDescriptor iItemPropertyDescriptor, Object object) {
        return super.getPropertyValue(iItemPropertyDescriptor, object);
    }

    protected void doSetPropertyValue(IItemPropertyDescriptor iItemPropertyDescriptor, Object object, Object object2) {
        super.setPropertyValue(iItemPropertyDescriptor, object, object2);
    }

    protected boolean doCanSetProperty(IItemPropertyDescriptor iItemPropertyDescriptor, Object object) {
        return super.canSetProperty(iItemPropertyDescriptor, object);
    }

    <V> V a(Callable<V> callable, V v, String string, Object ... objectArray) {
        try {
            return (V)Transactions.runExclusive((TransactionalEditingDomain)this.domain, callable);
        }
        catch (InterruptedException interruptedException) {
            a.debug("Interrupted", (Throwable)interruptedException);
            return v;
        }
        catch (CancellationException cancellationException) {
            a.debug("Cancelled: " + MessageFormat.format(string, objectArray), (Throwable)cancellationException);
            return v;
        }
        catch (ExecutionException executionException) {
            a.warn("Failed: " + MessageFormat.format(string, objectArray), executionException.getCause());
            return v;
        }
    }
}

