/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import net.astah.emf.common.transaction.Transactions;
import net.astah.emf.edit.provider.swing.AdapterFactoryContentProvider;
import net.astah.emf.edit.provider.swing.TransactionalPropertySource;
import net.astah.golf.view.swing.IPropertySource;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalAdapterFactoryContentProvider
extends AdapterFactoryContentProvider {
    private static final Logger a = LoggerFactory.getLogger(TransactionalAdapterFactoryContentProvider.class);
    protected final TransactionalEditingDomain domain;

    public TransactionalAdapterFactoryContentProvider(TransactionalEditingDomain transactionalEditingDomain, AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.domain = Objects.requireNonNull(transactionalEditingDomain, "domain");
    }

    @Override
    public Collection<?> getElements(Object object) {
        return this.a(() -> this.doGetElements(object), Collections.emptyList(), "get elements of {0}", object);
    }

    @Override
    public Collection<?> getChildren(Object object) {
        return this.a(() -> this.doGetChildren(object), Collections.emptyList(), "get children of {0}", object);
    }

    @Override
    public Object getParent(Object object) {
        return this.a(() -> this.doGetParent(object), null, "get parent of {0}", object);
    }

    @Override
    public boolean hasChildren(Object object) {
        return this.a(() -> this.doHasChildren(object), false, "get whether {0} has children", object);
    }

    @Override
    public IPropertySource getPropertySource(Object object) {
        IPropertySource iPropertySource = this.doGetPropertySource(object);
        if (iPropertySource == null) {
            return null;
        }
        return new TransactionalPropertySource(this.domain, iPropertySource);
    }

    protected Collection<?> doGetElements(Object object) {
        return super.getElements(object);
    }

    protected Collection<?> doGetChildren(Object object) {
        return super.getChildren(object);
    }

    protected Object doGetParent(Object object) {
        return super.getParent(object);
    }

    protected boolean doHasChildren(Object object) {
        return super.hasChildren(object);
    }

    protected IPropertySource doGetPropertySource(Object object) {
        return super.getPropertySource(object);
    }

    @Override
    protected AdapterFactoryContentProvider.RefreshQueue createQueue() {
        return new TransactionalRefreshQueue();
    }

    <V> V a(Callable<V> callable, V v, String string, Object ... objectArray) {
        try {
            return (V)Transactions.runExclusive((TransactionalEditingDomain)this.domain, callable);
        }
        catch (InterruptedException interruptedException) {
            a.debug("Interrupted", (Throwable)interruptedException);
            return v;
        }
        catch (CancellationException cancellationException) {
            a.debug("Cancelled: " + MessageFormat.format(string, objectArray), (Throwable)cancellationException);
            return v;
        }
        catch (ExecutionException executionException) {
            a.warn("Failed: " + MessageFormat.format(string, objectArray), executionException.getCause());
            return v;
        }
    }

    protected class TransactionalRefreshQueue
    extends AdapterFactoryContentProvider.RefreshQueue {
        private static final long serialVersionUID = 1L;

        protected TransactionalRefreshQueue() {
            super(TransactionalAdapterFactoryContentProvider.this);
        }

        @Override
        public void run() {
            try {
                Transactions.safeRunExclusive((TransactionalEditingDomain)TransactionalAdapterFactoryContentProvider.this.domain, () -> super.run()).get();
            }
            catch (ExecutionException executionException) {
                a.error("Failed to execute task", executionException.getCause());
            }
            catch (InterruptedException | CancellationException exception) {
                a.info("The task has been canceled: {}", (Object)this);
            }
        }
    }
}

