/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import net.astah.emf.edit.provider.swing.AdapterFactoryContentProvider;
import net.astah.emf.edit.provider.swing.AdapterFactoryTreeCellEditor;
import net.astah.emf.edit.provider.swing.ContentProviderTreeTableModel;
import net.astah.emf.edit.provider.swing.JComponentBuilder;
import net.astah.emf.edit.provider.swing.TransactionalAdapterFactoryTreeCellEditor;
import net.astah.emf.edit.provider.swing.TransactionalContentProviderTreeTableModel;
import net.astah.emf.edit.provider.swing.TransactionalLabelProviderTreeCellRenderer;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.view.swing.ITreeTableColumnProvider;
import net.astah.golf.view.swing.TreeTableColumnProvider;
import net.astah.golf.widget.swing.IInputProvider;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.IStructuredContentProvider;
import net.astah.golf.widget.swing.ITreeContentProvider;
import net.astah.golf.widget.swing.IViewerAdapter;
import net.astah.golf.widget.swing.LabelProviderTreeCellRenderer;
import net.astah.jomt.jview.JToolTipAwareTreeTable;
import net.astah.jomt.jview.JTreeTable;
import net.astah.jomt.jview.TreeTableModel;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class JTreeTableBuilder<Builder extends JTreeTableBuilder<?>>
extends JComponentBuilder<Builder, JTreeTable, ITreeContentProvider, ILabelProvider> {
    protected TreeTableModel model;
    protected TreeCellRenderer cellRenderer;
    protected TreeCellEditor cellEditor;
    protected IPropertySourceProvider propertySourceProvider;
    protected ITreeTableColumnProvider columnProvider;
    protected final List<ITableColumnProvider.IColumnDescriptor> columns = new ArrayList<ITableColumnProvider.IColumnDescriptor>();
    protected Object root;
    protected boolean editable;
    protected boolean toolTip = true;
    protected Icon closedIcon;
    protected Icon openIcon;
    protected Icon leafIcon;
    protected Icon defaultIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    protected JTreeTableBuilder() {
    }

    protected JTreeTableBuilder(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public static JTreeTableBuilder<?> builder() {
        return new JTreeTableBuilder();
    }

    public static JTreeTableBuilder<?> builder(EditingDomain editingDomain) {
        return new JTreeTableBuilder(editingDomain);
    }

    public static void dispose(JTreeTable jTreeTable) {
        TreeCellRenderer treeCellRenderer;
        TableModel tableModel = jTreeTable.getModel();
        if (tableModel instanceof IDisposable) {
            ((IDisposable)tableModel).dispose();
        }
        if ((treeCellRenderer = jTreeTable.getTree().getCellRenderer()) instanceof IDisposable) {
            ((IDisposable)treeCellRenderer).dispose();
        }
    }

    public static AdapterFactory getAdapterFactory(JTreeTable jTreeTable) {
        ITreeContentProvider iTreeContentProvider;
        TableModel tableModel = jTreeTable.getModel();
        if (tableModel instanceof ContentProviderTreeTableModel && (iTreeContentProvider = ((ContentProviderTreeTableModel)((Object)tableModel)).getContentProvider()) instanceof AdapterFactoryContentProvider) {
            return ((AdapterFactoryContentProvider)iTreeContentProvider).getAdapterFactory();
        }
        return null;
    }

    @Override
    public JTreeTable build() {
        return this.build(this.createTreeTable());
    }

    @Override
    public JTreeTable build(JTreeTable jTreeTable) {
        ContentProviderTreeTableModel contentProviderTreeTableModel;
        ITreeTableColumnProvider iTreeTableColumnProvider;
        TreeCellEditor treeCellEditor;
        TreeTableModel treeTableModel = this.prepareModel();
        if (treeTableModel != null) {
            jTreeTable.setTreeTableModel(treeTableModel);
        }
        JTree jTree = jTreeTable.getTree();
        TreeCellRenderer treeCellRenderer = this.prepareCellRenderer(jTreeTable, treeTableModel);
        if (treeCellRenderer != null) {
            jTree.setCellRenderer(treeCellRenderer);
        }
        if ((treeCellEditor = this.prepareCellEditor(jTreeTable, treeCellRenderer)) != null) {
            jTree.setCellEditor(treeCellEditor);
        }
        if (treeTableModel instanceof ContentProviderTreeTableModel && (iTreeTableColumnProvider = (contentProviderTreeTableModel = (ContentProviderTreeTableModel)treeTableModel).getTreeTableColumnProvider()) != null) {
            iTreeTableColumnProvider.update((JTable)jTreeTable, (IInputProvider)contentProviderTreeTableModel, contentProviderTreeTableModel.getPropertySourceProvider());
        }
        jTree.setEditable(this.editable);
        return jTreeTable;
    }

    public Builder model(TreeTableModel treeTableModel) {
        this.model = treeTableModel;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder cellRenderer(TreeCellRenderer treeCellRenderer) {
        this.cellRenderer = treeCellRenderer;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder cellEditor(TreeCellEditor treeCellEditor) {
        this.cellEditor = treeCellEditor;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder propertySourceProvider(IPropertySourceProvider iPropertySourceProvider) {
        this.propertySourceProvider = iPropertySourceProvider;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder columnProvider(ITreeTableColumnProvider iTreeTableColumnProvider) {
        this.columnProvider = iTreeTableColumnProvider;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder addColumn(ITableColumnProvider.IColumnDescriptor iColumnDescriptor) {
        this.columns.add(iColumnDescriptor);
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder root(Object object) {
        this.root = object;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder editable(boolean bl) {
        this.editable = bl;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder toolTip(boolean bl) {
        this.toolTip = bl;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder closedIcon(Icon icon) {
        this.closedIcon = icon;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder openIcon(Icon icon) {
        this.openIcon = icon;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder leafIcon(Icon icon) {
        this.leafIcon = icon;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder defaultIcon(Icon icon) {
        this.defaultIcon = icon;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder textSelectionColor(Color color) {
        this.textSelectionColor = color;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder textNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder backgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder backgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    public Builder borderSelectionColor(Color color) {
        this.borderSelectionColor = color;
        return (Builder)((JTreeTableBuilder)this.builder);
    }

    protected JTreeTable createTreeTable() {
        return this.toolTip ? new JToolTipAwareTreeTable() : new JTreeTable();
    }

    protected TreeTableModel prepareModel() {
        TreeTableModel treeTableModel = this.model != null ? this.model : this.createModel();
        if (this.root != null && treeTableModel instanceof IViewerAdapter) {
            ((IViewerAdapter)treeTableModel).setInput(this.root);
        }
        return treeTableModel;
    }

    protected TreeTableModel createModel() {
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.prepareContentProvider();
        IPropertySourceProvider iPropertySourceProvider = this.preparePropertySourceProvider((IStructuredContentProvider)iTreeContentProvider);
        ITreeTableColumnProvider iTreeTableColumnProvider = this.prepareColumnProvider();
        if (this.domain instanceof TransactionalEditingDomain) {
            TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)this.domain;
            return new TransactionalContentProviderTreeTableModel(transactionalEditingDomain, iTreeContentProvider, iPropertySourceProvider, iTreeTableColumnProvider);
        }
        return new ContentProviderTreeTableModel(iTreeContentProvider, iPropertySourceProvider, iTreeTableColumnProvider);
    }

    protected TreeCellRenderer prepareCellRenderer(JTreeTable jTreeTable, TreeTableModel treeTableModel) {
        TreeCellRenderer treeCellRenderer = this.cellRenderer != null ? this.cellRenderer : this.createCellRenderer(jTreeTable, treeTableModel);
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            if (this.font != null) {
                defaultTreeCellRenderer.setFont(this.font);
            }
            if (this.closedIcon != null) {
                defaultTreeCellRenderer.setClosedIcon(this.closedIcon);
            } else if (this.defaultIcon != null && this.a(defaultTreeCellRenderer.getClosedIcon())) {
                defaultTreeCellRenderer.setClosedIcon(this.defaultIcon);
            }
            if (this.openIcon != null) {
                defaultTreeCellRenderer.setOpenIcon(this.openIcon);
            } else if (this.defaultIcon != null && this.a(defaultTreeCellRenderer.getOpenIcon())) {
                defaultTreeCellRenderer.setOpenIcon(this.defaultIcon);
            }
            if (this.leafIcon != null) {
                defaultTreeCellRenderer.setLeafIcon(this.leafIcon);
            } else if (this.defaultIcon != null && this.a(defaultTreeCellRenderer.getLeafIcon())) {
                defaultTreeCellRenderer.setLeafIcon(this.defaultIcon);
            }
            if (this.textSelectionColor != null) {
                defaultTreeCellRenderer.setTextSelectionColor(this.textSelectionColor);
            }
            if (this.textNonSelectionColor != null) {
                defaultTreeCellRenderer.setTextNonSelectionColor(this.textNonSelectionColor);
            }
            if (this.backgroundSelectionColor != null) {
                defaultTreeCellRenderer.setBackgroundSelectionColor(this.backgroundSelectionColor);
            }
            if (this.backgroundNonSelectionColor != null) {
                defaultTreeCellRenderer.setBackgroundNonSelectionColor(this.backgroundNonSelectionColor);
            }
            if (this.borderSelectionColor != null) {
                defaultTreeCellRenderer.setBorderSelectionColor(this.borderSelectionColor);
            }
        }
        return treeCellRenderer;
    }

    protected TreeCellRenderer createCellRenderer(JTreeTable jTreeTable, TreeTableModel treeTableModel) {
        ILabelProvider iLabelProvider = this.prepareLabelProvider(jTreeTable);
        if (this.domain instanceof TransactionalEditingDomain) {
            TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)this.domain;
            return new TransactionalLabelProviderTreeCellRenderer(transactionalEditingDomain, iLabelProvider);
        }
        return new LabelProviderTreeCellRenderer(iLabelProvider);
    }

    protected TreeCellEditor prepareCellEditor(JTreeTable jTreeTable, TreeCellRenderer treeCellRenderer) {
        if (this.cellEditor != null) {
            return this.cellEditor;
        }
        if (this.editable) {
            return this.createCellEditor(jTreeTable, treeCellRenderer);
        }
        return null;
    }

    protected TreeCellEditor createCellEditor(JTreeTable jTreeTable, TreeCellRenderer treeCellRenderer) {
        if (!(treeCellRenderer instanceof DefaultTreeCellRenderer)) {
            throw new IllegalArgumentException("cellRenderer must be DefaultTreeCellRenderer");
        }
        JTree jTree = jTreeTable.getTree();
        AdapterFactory adapterFactory = this.acquireAdapterFactory();
        if (this.domain instanceof TransactionalEditingDomain) {
            TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)this.domain;
            return new TransactionalAdapterFactoryTreeCellEditor(jTree, (DefaultTreeCellRenderer)treeCellRenderer, transactionalEditingDomain, adapterFactory);
        }
        return new AdapterFactoryTreeCellEditor(jTree, (DefaultTreeCellRenderer)treeCellRenderer, adapterFactory);
    }

    @Override
    protected ILabelProvider prepareLabelProvider(JTreeTable jTreeTable) {
        TreeTableColumnProvider.HierarchicalColumnDescriptor hierarchicalColumnDescriptor = this.getHierarchicalColumnDescriptor();
        if (hierarchicalColumnDescriptor == null) {
            return (ILabelProvider)super.prepareLabelProvider(jTreeTable);
        }
        ILabelProvider iLabelProvider = hierarchicalColumnDescriptor.getLabelProvider();
        if (iLabelProvider != null) {
            return iLabelProvider;
        }
        ILabelProvider iLabelProvider2 = (ILabelProvider)super.prepareLabelProvider(jTreeTable);
        hierarchicalColumnDescriptor.setLabelProvider(iLabelProvider2);
        return iLabelProvider2;
    }

    protected TreeTableColumnProvider.HierarchicalColumnDescriptor getHierarchicalColumnDescriptor() {
        for (ITableColumnProvider.IColumnDescriptor iColumnDescriptor : this.columns) {
            if (!(iColumnDescriptor instanceof TreeTableColumnProvider.HierarchicalColumnDescriptor)) continue;
            return (TreeTableColumnProvider.HierarchicalColumnDescriptor)iColumnDescriptor;
        }
        return null;
    }

    protected IPropertySourceProvider preparePropertySourceProvider(IStructuredContentProvider iStructuredContentProvider) {
        if (this.propertySourceProvider != null) {
            return this.propertySourceProvider;
        }
        if (iStructuredContentProvider instanceof IPropertySourceProvider) {
            return (IPropertySourceProvider)iStructuredContentProvider;
        }
        return null;
    }

    protected ITreeTableColumnProvider prepareColumnProvider() {
        if (this.columnProvider != null) {
            return this.columnProvider;
        }
        return this.createColumnProvider();
    }

    protected ITreeTableColumnProvider createColumnProvider() {
        return new TreeTableColumnProvider(this.columns);
    }

    boolean a(Icon icon) {
        return icon == null || icon instanceof UIResource;
    }
}

