/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.awt.Color;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.plaf.UIResource;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import net.astah.emf.edit.provider.swing.AdapterFactoryContentProvider;
import net.astah.emf.edit.provider.swing.AdapterFactoryTreeCellEditor;
import net.astah.emf.edit.provider.swing.ContentProviderTreeModel;
import net.astah.emf.edit.provider.swing.JComponentBuilder;
import net.astah.emf.edit.provider.swing.TransactionalAdapterFactoryTreeCellEditor;
import net.astah.emf.edit.provider.swing.TransactionalContentProviderTreeModel;
import net.astah.emf.edit.provider.swing.TransactionalLabelProviderTreeCellRenderer;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.ITreeContentProvider;
import net.astah.golf.widget.swing.IViewerAdapter;
import net.astah.golf.widget.swing.LabelProviderTreeCellRenderer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class JTreeBuilder<Builder extends JTreeBuilder<?>>
extends JComponentBuilder<Builder, JTree, ITreeContentProvider, ILabelProvider> {
    protected TreeModel model;
    protected TreeCellRenderer cellRenderer;
    protected TreeCellEditor cellEditor;
    protected Object root;
    protected boolean editable;
    protected Icon closedIcon;
    protected Icon openIcon;
    protected Icon leafIcon;
    protected Icon defaultIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    protected JTreeBuilder() {
    }

    protected JTreeBuilder(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public static JTreeBuilder<?> builder() {
        return new JTreeBuilder();
    }

    public static JTreeBuilder<?> builder(EditingDomain editingDomain) {
        return new JTreeBuilder(editingDomain);
    }

    public static void dispose(JTree jTree) {
        TreeCellEditor treeCellEditor;
        TreeCellRenderer treeCellRenderer;
        TreeModel treeModel = jTree.getModel();
        if (treeModel instanceof IDisposable) {
            ((IDisposable)treeModel).dispose();
        }
        if ((treeCellRenderer = jTree.getCellRenderer()) instanceof IDisposable) {
            ((IDisposable)treeCellRenderer).dispose();
        }
        if ((treeCellEditor = jTree.getCellEditor()) instanceof IDisposable) {
            ((IDisposable)treeCellEditor).dispose();
        }
    }

    public static AdapterFactory getAdapterFactory(JTree jTree) {
        ITreeContentProvider iTreeContentProvider;
        TreeModel treeModel = jTree.getModel();
        if (treeModel instanceof ContentProviderTreeModel && (iTreeContentProvider = ((ContentProviderTreeModel)((Object)treeModel)).getContentProvider()) instanceof AdapterFactoryContentProvider) {
            return ((AdapterFactoryContentProvider)iTreeContentProvider).getAdapterFactory();
        }
        return null;
    }

    @Override
    public JTree build() {
        return this.build(this.createTree());
    }

    @Override
    public JTree build(JTree jTree) {
        TreeModel treeModel;
        TreeCellEditor treeCellEditor;
        TreeCellRenderer treeCellRenderer = this.prepareCellRenderer(jTree);
        if (treeCellRenderer != null) {
            jTree.setCellRenderer(treeCellRenderer);
        }
        if ((treeCellEditor = this.prepareCellEditor(jTree, treeCellRenderer)) != null) {
            jTree.setCellEditor(treeCellEditor);
        }
        if ((treeModel = this.prepareModel()) != null) {
            jTree.setModel(treeModel);
        }
        jTree.setEditable(this.editable);
        if (this.transferHandler != null) {
            jTree.setDragEnabled(true);
            jTree.setDropMode(DropMode.INSERT);
            jTree.setTransferHandler(this.transferHandler);
        }
        return jTree;
    }

    public Builder model(TreeModel treeModel) {
        this.model = treeModel;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder cellRenderer(TreeCellRenderer treeCellRenderer) {
        this.cellRenderer = treeCellRenderer;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder cellEditor(TreeCellEditor treeCellEditor) {
        this.cellEditor = treeCellEditor;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder root(Object object) {
        this.root = object;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder editable(boolean bl) {
        this.editable = bl;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder closedIcon(Icon icon) {
        this.closedIcon = icon;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder openIcon(Icon icon) {
        this.openIcon = icon;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder leafIcon(Icon icon) {
        this.leafIcon = icon;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder defaultIcon(Icon icon) {
        this.defaultIcon = icon;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder textSelectionColor(Color color) {
        this.textSelectionColor = color;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder textNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder backgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder backgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
        return (Builder)((JTreeBuilder)this.builder);
    }

    public Builder borderSelectionColor(Color color) {
        this.borderSelectionColor = color;
        return (Builder)((JTreeBuilder)this.builder);
    }

    protected JTree createTree() {
        return new JTree();
    }

    protected TreeModel prepareModel() {
        TreeModel treeModel = this.model != null ? this.model : this.createModel();
        if (this.root != null && treeModel instanceof IViewerAdapter) {
            ((IViewerAdapter)treeModel).setInput(this.root);
        }
        return treeModel;
    }

    protected TreeModel createModel() {
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.prepareContentProvider();
        if (this.domain instanceof TransactionalEditingDomain) {
            TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)this.domain;
            return new TransactionalContentProviderTreeModel(transactionalEditingDomain, iTreeContentProvider);
        }
        return new ContentProviderTreeModel(iTreeContentProvider);
    }

    protected TreeCellRenderer prepareCellRenderer(JTree jTree) {
        TreeCellRenderer treeCellRenderer = this.cellRenderer != null ? this.cellRenderer : this.createCellRenderer(jTree);
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            if (this.font != null) {
                defaultTreeCellRenderer.setFont(this.font);
            }
            if (this.closedIcon != null) {
                defaultTreeCellRenderer.setClosedIcon(this.closedIcon);
            } else if (this.defaultIcon != null && this.a(defaultTreeCellRenderer.getClosedIcon())) {
                defaultTreeCellRenderer.setClosedIcon(this.defaultIcon);
            }
            if (this.openIcon != null) {
                defaultTreeCellRenderer.setOpenIcon(this.openIcon);
            } else if (this.defaultIcon != null && this.a(defaultTreeCellRenderer.getOpenIcon())) {
                defaultTreeCellRenderer.setOpenIcon(this.defaultIcon);
            }
            if (this.leafIcon != null) {
                defaultTreeCellRenderer.setLeafIcon(this.leafIcon);
            } else if (this.defaultIcon != null && this.a(defaultTreeCellRenderer.getLeafIcon())) {
                defaultTreeCellRenderer.setLeafIcon(this.defaultIcon);
            }
            if (this.textSelectionColor != null) {
                defaultTreeCellRenderer.setTextSelectionColor(this.textSelectionColor);
            }
            if (this.textNonSelectionColor != null) {
                defaultTreeCellRenderer.setTextNonSelectionColor(this.textNonSelectionColor);
            }
            if (this.backgroundSelectionColor != null) {
                defaultTreeCellRenderer.setBackgroundSelectionColor(this.backgroundSelectionColor);
            }
            if (this.backgroundNonSelectionColor != null) {
                defaultTreeCellRenderer.setBackgroundNonSelectionColor(this.backgroundNonSelectionColor);
            }
            if (this.borderSelectionColor != null) {
                defaultTreeCellRenderer.setBorderSelectionColor(this.borderSelectionColor);
            }
        }
        return treeCellRenderer;
    }

    protected TreeCellRenderer createCellRenderer(JTree jTree) {
        ILabelProvider iLabelProvider = (ILabelProvider)this.prepareLabelProvider(jTree);
        if (this.domain instanceof TransactionalEditingDomain) {
            TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)this.domain;
            return new TransactionalLabelProviderTreeCellRenderer(transactionalEditingDomain, iLabelProvider);
        }
        return new LabelProviderTreeCellRenderer(iLabelProvider);
    }

    protected TreeCellEditor prepareCellEditor(JTree jTree, TreeCellRenderer treeCellRenderer) {
        if (this.cellEditor != null) {
            return this.cellEditor;
        }
        if (this.editable) {
            return this.createCellEditor(jTree, treeCellRenderer);
        }
        return null;
    }

    protected TreeCellEditor createCellEditor(JTree jTree, TreeCellRenderer treeCellRenderer) {
        if (!(treeCellRenderer instanceof DefaultTreeCellRenderer)) {
            throw new IllegalArgumentException("cellRenderer must be DefaultTreeCellRenderer");
        }
        AdapterFactory adapterFactory = this.acquireAdapterFactory();
        if (this.domain instanceof TransactionalEditingDomain) {
            TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)this.domain;
            return new TransactionalAdapterFactoryTreeCellEditor(jTree, (DefaultTreeCellRenderer)treeCellRenderer, transactionalEditingDomain, adapterFactory);
        }
        return new AdapterFactoryTreeCellEditor(jTree, (DefaultTreeCellRenderer)treeCellRenderer, adapterFactory);
    }

    boolean a(Icon icon) {
        return icon == null || icon instanceof UIResource;
    }
}

