/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableModel;
import net.astah.emf.edit.provider.swing.AdapterFactoryContentProvider;
import net.astah.emf.edit.provider.swing.ContentProviderTableModel;
import net.astah.emf.edit.provider.swing.JComponentBuilder;
import net.astah.emf.edit.provider.swing.TransactionalContentProviderTableModel;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.view.swing.TableColumnProvider;
import net.astah.golf.widget.swing.AdjustedRowHeightTable;
import net.astah.golf.widget.swing.IInputProvider;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.IStructuredContentProvider;
import net.astah.golf.widget.swing.IViewerAdapter;
import net.astah.jomt.jview.JToolTipAwareTable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class JTableBuilder<Builder extends JTableBuilder<?>>
extends JComponentBuilder<Builder, JTable, IStructuredContentProvider, ILabelProvider> {
    protected TableModel model;
    protected IPropertySourceProvider propertySourceProvider;
    protected ITableColumnProvider columnProvider;
    protected final List<ITableColumnProvider.IColumnDescriptor> columns = new ArrayList<ITableColumnProvider.IColumnDescriptor>();
    protected Object input;
    protected boolean toolTip = true;
    protected boolean reorderingAllowed = true;

    protected JTableBuilder() {
    }

    protected JTableBuilder(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public static JTableBuilder<?> builder() {
        return new JTableBuilder();
    }

    public static JTableBuilder<?> builder(EditingDomain editingDomain) {
        return new JTableBuilder(editingDomain);
    }

    public static void dispose(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        if (tableModel instanceof IDisposable) {
            ((IDisposable)tableModel).dispose();
        }
    }

    public static AdapterFactory getAdapterFactory(JTable jTable) {
        IStructuredContentProvider iStructuredContentProvider;
        TableModel tableModel = jTable.getModel();
        if (tableModel instanceof ContentProviderTableModel && (iStructuredContentProvider = ((ContentProviderTableModel)((Object)tableModel)).getContentProvider()) instanceof AdapterFactoryContentProvider) {
            return ((AdapterFactoryContentProvider)iStructuredContentProvider).getAdapterFactory();
        }
        return null;
    }

    @Override
    public JTable build() {
        return this.build(this.createTable());
    }

    @Override
    public JTable build(JTable jTable) {
        ContentProviderTableModel contentProviderTableModel;
        ITableColumnProvider iTableColumnProvider;
        TableModel tableModel;
        if (GolfUtilities.isMacOS()) {
            jTable.setGridColor(Color.LIGHT_GRAY);
        }
        if (this.font != null) {
            jTable.setFont(this.font);
            jTable.getTableHeader().setFont(this.font);
        }
        if ((tableModel = this.prepareModel()) != null) {
            jTable.setModel(tableModel);
        }
        if (tableModel instanceof ContentProviderTableModel && (iTableColumnProvider = (contentProviderTableModel = (ContentProviderTableModel)((Object)tableModel)).getColumnProvider()) != null) {
            iTableColumnProvider.update(jTable, (IInputProvider)contentProviderTableModel, contentProviderTableModel.getPropertySourceProvider());
        }
        if (this.transferHandler != null) {
            jTable.setDragEnabled(true);
            jTable.setDropMode(DropMode.INSERT_ROWS);
            jTable.setTransferHandler(this.transferHandler);
        }
        jTable.getTableHeader().setReorderingAllowed(this.reorderingAllowed);
        return jTable;
    }

    public Builder model(TableModel tableModel) {
        this.model = tableModel;
        return (Builder)((JTableBuilder)this.builder);
    }

    public Builder propertySourceProvider(IPropertySourceProvider iPropertySourceProvider) {
        this.propertySourceProvider = iPropertySourceProvider;
        return (Builder)((JTableBuilder)this.builder);
    }

    public Builder columnProvider(ITableColumnProvider iTableColumnProvider) {
        this.columnProvider = iTableColumnProvider;
        return (Builder)((JTableBuilder)this.builder);
    }

    public Builder addColumn(ITableColumnProvider.IColumnDescriptor iColumnDescriptor) {
        this.columns.add(iColumnDescriptor);
        return (Builder)((JTableBuilder)this.builder);
    }

    public Builder input(Object object) {
        this.input = object;
        return (Builder)((JTableBuilder)this.builder);
    }

    public Builder toolTip(boolean bl) {
        this.toolTip = bl;
        return (Builder)((JTableBuilder)this.builder);
    }

    public Builder reorderingAllowed(boolean bl) {
        this.reorderingAllowed = bl;
        return (Builder)((JTableBuilder)this.builder);
    }

    protected JTable createTable() {
        return this.toolTip ? new JToolTipAwareTable() : new AdjustedRowHeightTable();
    }

    protected TableModel prepareModel() {
        TableModel tableModel = this.model != null ? this.model : this.createModel();
        if (this.input != null && tableModel instanceof IViewerAdapter) {
            ((IViewerAdapter)tableModel).setInput(this.input);
        }
        return tableModel;
    }

    protected TableModel createModel() {
        IStructuredContentProvider iStructuredContentProvider = (IStructuredContentProvider)this.prepareContentProvider();
        IPropertySourceProvider iPropertySourceProvider = this.preparePropertySourceProvider(iStructuredContentProvider);
        ITableColumnProvider iTableColumnProvider = this.prepareColumnProvider();
        if (this.domain instanceof TransactionalEditingDomain) {
            TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)this.domain;
            return new TransactionalContentProviderTableModel(transactionalEditingDomain, iStructuredContentProvider, iPropertySourceProvider, iTableColumnProvider);
        }
        return new ContentProviderTableModel(iStructuredContentProvider, iPropertySourceProvider, iTableColumnProvider);
    }

    protected IPropertySourceProvider preparePropertySourceProvider(IStructuredContentProvider iStructuredContentProvider) {
        if (this.propertySourceProvider != null) {
            return this.propertySourceProvider;
        }
        if (iStructuredContentProvider instanceof IPropertySourceProvider) {
            return (IPropertySourceProvider)iStructuredContentProvider;
        }
        return null;
    }

    protected ITableColumnProvider prepareColumnProvider() {
        if (this.columnProvider != null) {
            return this.columnProvider;
        }
        return this.createColumnProvider();
    }

    protected ITableColumnProvider createColumnProvider() {
        return new TableColumnProvider(this.columns);
    }

    boolean a(Icon icon) {
        return icon == null || icon instanceof UIResource;
    }
}

