/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import com.google.common.base.Strings;
import java.awt.Font;
import org.eclipse.emf.common.util.URI;

public class FontURIResolver {
    private final Font a;

    public FontURIResolver(Font font) {
        this.a = font;
    }

    public Font resolve(URI uRI) {
        if ("font".equalsIgnoreCase(uRI.scheme())) {
            String string = this.a(uRI);
            float f = this.b(uRI);
            int n = this.c(uRI);
            if (this.a != null) {
                if (string != null) {
                    if (Float.isNaN(f)) {
                        f = this.a.getSize2D();
                    }
                    if (n < 0) {
                        n = this.a.getStyle();
                    }
                } else {
                    if (!Float.isNaN(f) && n >= 0) {
                        return this.a.deriveFont(n, f);
                    }
                    if (!Float.isNaN(f)) {
                        return this.a.deriveFont(f);
                    }
                    if (n >= 0) {
                        return this.a.deriveFont(n);
                    }
                    return this.a;
                }
            }
            if (string != null && !Float.isNaN(f) && n >= 0) {
                if (this.a(this.a, string, f, n)) {
                    return this.a;
                }
                return new Font(string, n, (int)f).deriveFont(f);
            }
        }
        return this.a;
    }

    String a(URI uRI) {
        String string = uRI.authority();
        return Strings.isNullOrEmpty((String)string) ? null : string;
    }

    float b(URI uRI) {
        String string;
        if (uRI.segmentCount() >= 1 && !(string = uRI.segment(0)).isEmpty()) {
            try {
                return this.a(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Illegal font size segment: " + string);
            }
        }
        return Float.NaN;
    }

    float a(String string) {
        char c2 = string.charAt(0);
        switch (c2) {
            case '+': 
            case '-': {
                break;
            }
            default: {
                return Float.parseFloat(string);
            }
        }
        if (this.a == null) {
            throw new IllegalArgumentException("Delta size requires current font: " + string);
        }
        float f = Float.parseFloat(string.substring(1));
        return this.a.getSize2D() + (c2 == '+' ? f : -f);
    }

    int c(URI uRI) {
        if (uRI.segmentCount() >= 2) {
            switch (uRI.segment(1)) {
                case "normal": {
                    return 0;
                }
                case "bold": {
                    return 1;
                }
                case "italic": {
                    return 2;
                }
                case "bold+italic": {
                    return 3;
                }
            }
        }
        return -1;
    }

    boolean a(Font font, String string, float f, int n) {
        if (font == null) {
            return false;
        }
        if (!string.equals(font.getName())) {
            return false;
        }
        if (f != font.getSize2D()) {
            return false;
        }
        return n == font.getStyle();
    }
}

