/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.common.notify.EFeaturePathObserver;
import net.astah.emf.edit.provider.swing.AdapterFactoryContentProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class FeaturePathContentProvider
extends AdapterFactoryContentProvider {
    protected EFeaturePathObserver observer = EFeaturePathObserver.create();
    protected Map<EFeaturePath, IDisposable> paths = new LinkedHashMap<EFeaturePath, IDisposable>();
    private final EFeaturePathObserver.Listener a = event -> {
        for (EObject eObject : event.getAffectedObjects()) {
            ViewerNotification viewerNotification = new ViewerNotification(event.getNotification(), (Object)eObject, true, false);
            if (!this.queue.offerAndWasEmpty((IViewerNotification)viewerNotification)) continue;
            this.asyncExec(this.queue);
        }
    };

    public FeaturePathContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public void addPath(@NonNull EFeaturePath eFeaturePath2) {
        if (eFeaturePath2 == null) {
            throw new NullPointerException("path");
        }
        this.paths.computeIfAbsent(eFeaturePath2, eFeaturePath -> this.observer.observe(eFeaturePath, this.a));
    }

    public void removePath(EFeaturePath eFeaturePath) {
        IDisposable iDisposable = this.paths.remove(eFeaturePath);
        if (iDisposable != null) {
            iDisposable.dispose();
        }
    }

    @Override
    public Collection<?> getElements(Object object) {
        return this.getChildren(object);
    }

    @Override
    public Collection<?> getChildren(Object object) {
        Set<Object> set = Collections.emptySet();
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            for (EFeaturePath eFeaturePath : this.paths.keySet()) {
                Set<Object> set2 = this.getReferences(eFeaturePath, eObject);
                if (set2.isEmpty()) continue;
                if (set.isEmpty()) {
                    set = set2;
                    continue;
                }
                set.addAll(set2);
            }
        }
        return set;
    }

    @Override
    public Object getParent(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            for (EFeaturePath eFeaturePath : this.paths.keySet()) {
                Set<EObject> set = this.getInverseReferences(eFeaturePath, eObject);
                if (set.isEmpty()) continue;
                return set.iterator().next();
            }
        }
        return null;
    }

    @Override
    public boolean hasChildren(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            for (EFeaturePath eFeaturePath : this.paths.keySet()) {
                if (this.getReferences(eFeaturePath, eObject).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.viewer != null && !this.viewer.isDisposed()) {
            this.observer.notifyChanged(notification);
        }
    }

    @Override
    public void dispose() {
        this.paths.values().forEach(IDisposable::dispose);
        this.paths.clear();
        super.dispose();
    }

    protected Set<Object> getReferences(EFeaturePath eFeaturePath, EObject eObject) {
        return (Set)eFeaturePath.getFirst().getReferences(eObject, null, LinkedHashSet::new);
    }

    protected Set<EObject> getInverseReferences(EFeaturePath eFeaturePath, EObject eObject) {
        return (Set)eFeaturePath.getLast().getInverseReferences(eObject, null, LinkedHashSet::new);
    }
}

