/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import com.google.common.collect.FluentIterable;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.Collection;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import net.astah.emf.edit.provider.swing.EditingDomainTransferHandler;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EditingDomainTreeTransferHandler
extends EditingDomainTransferHandler {
    private static final long serialVersionUID = 1L;

    public EditingDomainTreeTransferHandler(EditingDomain editingDomain) {
        super(editingDomain);
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        Object[] objectArray = this.createTransferData(jComponent).toArray();
        return new DataHandler((Object)objectArray, LOCAL_OBJECT_FLAVOR.getMimeType());
    }

    @Override
    protected Collection<?> createTransferData(JComponent jComponent) {
        JTree jTree = (JTree)jComponent;
        return FluentIterable.from(Arrays.asList(jTree.getSelectionPaths())).transform(TreePath::getLastPathComponent).toList();
    }

    @Override
    protected Command createCommand(TransferHandler.TransferSupport transferSupport) {
        Component component = transferSupport.getComponent();
        if (!(component instanceof JTree)) {
            return UnexecutableCommand.INSTANCE;
        }
        JTree jTree = (JTree)component;
        if (!transferSupport.isDrop() || !transferSupport.isDataFlavorSupported(LOCAL_OBJECT_FLAVOR)) {
            return UnexecutableCommand.INSTANCE;
        }
        Object object = jTree.getSelectionPath().getLastPathComponent();
        if (object == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Point point = transferSupport.getDropLocation().getDropPoint();
        TreePath treePath = jTree.getClosestPathForLocation((int)point.getX(), (int)point.getY());
        Object object2 = treePath.getLastPathComponent();
        Rectangle rectangle = jTree.getPathBounds(treePath);
        float f = (float)((point.getY() - rectangle.getY()) / rectangle.getHeight());
        int n = this.convertActionToOperation(this.getSourceActions(jTree));
        int n2 = this.convertActionToOperation(transferSupport.getDropAction());
        Collection<?> collection = this.getTransferData(transferSupport);
        return DragAndDropCommand.create((EditingDomain)this.domain, (Object)object2, (float)f, (int)n, (int)n2, collection);
    }
}

