/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import lombok.NonNull;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;

public abstract class EditingDomainTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    protected static final DataFlavor LOCAL_OBJECT_FLAVOR = new ActivationDataFlavor(Object[].class, "application/x-java-jvm-local-objectref", "LocalObject");
    protected final EditingDomain domain;

    public EditingDomainTransferHandler(@NonNull EditingDomain editingDomain) {
        if (editingDomain == null) {
            throw new NullPointerException("domain");
        }
        this.domain = editingDomain;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        Command command = this.createCommand(transferSupport);
        boolean bl = command.canExecute();
        command.dispose();
        return bl;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        Command command = this.createCommand(transferSupport);
        if (!command.canExecute()) {
            command.dispose();
            return false;
        }
        this.executeCommand(command);
        return true;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        Object[] objectArray = this.createTransferData(jComponent).toArray();
        return new DataHandler((Object)objectArray, LOCAL_OBJECT_FLAVOR.getMimeType());
    }

    protected abstract Collection<?> createTransferData(JComponent var1);

    protected abstract Command createCommand(TransferHandler.TransferSupport var1);

    protected void executeCommand(Command command) {
        this.domain.getCommandStack().execute(command);
    }

    protected Collection<?> getTransferData(TransferHandler.TransferSupport transferSupport) {
        try {
            Transferable transferable = transferSupport.getTransferable();
            Object[] objectArray = (Object[])transferable.getTransferData(LOCAL_OBJECT_FLAVOR);
            return Collections.unmodifiableList(Arrays.asList(objectArray));
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return Collections.emptyList();
        }
    }

    protected int convertActionToOperation(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 0x40000000) != 0) {
            n2 |= 4;
        }
        return n2;
    }
}

