/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.awt.Component;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.TableModel;
import net.astah.emf.edit.provider.swing.EditingDomainTransferHandler;
import net.astah.golf.widget.swing.ContentTableModel;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.DragAndDropFeedback;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EditingDomainTableTransferHandler
extends EditingDomainTransferHandler {
    private static final long serialVersionUID = 1L;

    public EditingDomainTableTransferHandler(EditingDomain editingDomain) {
        super(editingDomain);
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 2;
    }

    @Override
    protected Collection<?> createTransferData(JComponent jComponent) {
        JTable jTable = (JTable)jComponent;
        TableModel tableModel = jTable.getModel();
        if (!(tableModel instanceof ContentTableModel)) {
            return null;
        }
        ContentTableModel contentTableModel = (ContentTableModel)tableModel;
        int[] nArray = jTable.getSelectedRows();
        return IntStream.of(nArray).mapToObj(arg_0 -> ((ContentTableModel)contentTableModel).getRowAt(arg_0)).collect(Collectors.toList());
    }

    @Override
    protected Command createCommand(TransferHandler.TransferSupport transferSupport) {
        Component component = transferSupport.getComponent();
        if (!(component instanceof JTable)) {
            return UnexecutableCommand.INSTANCE;
        }
        JTable jTable = (JTable)component;
        if (!transferSupport.isDrop() || !transferSupport.isDataFlavorSupported(LOCAL_OBJECT_FLAVOR)) {
            return UnexecutableCommand.INSTANCE;
        }
        JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
        int n = dropLocation.getRow();
        if (n < 0) {
            return UnexecutableCommand.INSTANCE;
        }
        TableModel tableModel = jTable.getModel();
        if (!(tableModel instanceof ContentTableModel)) {
            return UnexecutableCommand.INSTANCE;
        }
        ContentTableModel contentTableModel = (ContentTableModel)tableModel;
        boolean bl = n >= jTable.getRowCount();
        int n2 = jTable.convertRowIndexToModel(bl ? n - 1 : n);
        Object object = contentTableModel.getRowAt(n2);
        float f = dropLocation.isInsertRow() && !bl ? 0.0f : 1.0f;
        int n3 = this.convertActionToOperation(this.getSourceActions(jTable));
        int n4 = this.convertActionToOperation(transferSupport.getDropAction());
        Collection<?> collection = this.getTransferData(transferSupport);
        Command command = DragAndDropCommand.create((EditingDomain)this.domain, (Object)object, (float)f, (int)n3, (int)n4, collection);
        DropMode dropMode = jTable.getDropMode();
        if (command.canExecute() && dropMode != null) {
            block0 : switch (dropMode) {
                case INSERT: 
                case INSERT_ROWS: 
                case INSERT_COLS: {
                    if (!(command instanceof DragAndDropFeedback)) break;
                    switch (((DragAndDropFeedback)command).getFeedback()) {
                        case 2: 
                        case 4: {
                            break block0;
                        }
                    }
                    command.dispose();
                    return UnexecutableCommand.INSTANCE;
                }
            }
        }
        return command;
    }
}

