/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import com.google.common.base.Equivalence;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import net.astah.common.collect.MoreLists;
import net.astah.golf.widget.swing.IStructuredViewerAdapter;
import net.astah.golf.widget.swing.ITreeContentProvider;
import net.astah.golf.widget.swing.IViewerAdapter;
import net.astah.golf.widget.swing.NavigableTreeModel;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.edit.provider.IDisposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ContentProviderTreeModel
implements IStructuredViewerAdapter,
NavigableTreeModel,
IDisposable {
    private static final Logger a = LoggerFactory.getLogger(ContentProviderTreeModel.class);
    private static final Marker b = MarkerFactory.getMarker((String)"provider");
    private final List<TreeModelListener> c = new CopyOnWriteArrayList<TreeModelListener>();
    private final Map<Object, List<Object>> d = this.useEquals() ? new HashMap() : new IdentityHashMap();
    protected ITreeContentProvider contentProvider;
    protected Object root;

    public ContentProviderTreeModel(ITreeContentProvider iTreeContentProvider) {
        this.contentProvider = iTreeContentProvider;
    }

    public ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(ITreeContentProvider iTreeContentProvider) {
        if (this.contentProvider != null) {
            this.contentProvider.inputChanged(null, this.root, null);
        }
        if (iTreeContentProvider != null && this.root != null) {
            iTreeContentProvider.inputChanged((IViewerAdapter)this, null, this.root);
        }
        this.contentProvider = iTreeContentProvider;
    }

    public void dispose() {
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
            this.contentProvider = null;
        }
        this.setInput(null);
    }

    public boolean isDisposed() {
        return this.c.isEmpty();
    }

    public Object getInput() {
        return this.getRoot();
    }

    public void setInput(Object object) {
        this.setRoot(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Map<Object, List<Object>> map = this.d;
        synchronized (map) {
            this.resetState();
        }
        this.fireTreeStructureChanged(null, null, null);
    }

    public void refresh(Object object) {
        this.refreshContent(object);
    }

    public void update(Object object) {
        this.updateLabel(object);
    }

    public Object getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoot(Object object) {
        Object object2 = this.root;
        if (!this.a().equivalent(object2, object)) {
            Map<Object, List<Object>> map = this.d;
            synchronized (map) {
                this.resetState();
                this.root = object;
            }
            if (this.contentProvider != null) {
                this.contentProvider.inputChanged((IViewerAdapter)this, object2, object);
            }
        }
    }

    public Object getChild(Object object, int n) {
        return this.contents(object).get(n);
    }

    public int getChildCount(Object object) {
        return this.contents(object).size();
    }

    public Object getParent(Object object) {
        return this.getParentNode(object);
    }

    public Object getParentNode(Object object) {
        if (!this.isRoot(object)) {
            return this.contentProvider.getParent(object);
        }
        return null;
    }

    public Object[] getPathToRoot(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (object != null) {
            arrayList.add(object);
            if (this.isRoot(object)) {
                Collections.reverse(arrayList);
                return arrayList.toArray();
            }
            object = this.getParentNode(object);
        }
        return null;
    }

    public boolean isLeaf(Object object) {
        return this.contents(object).isEmpty();
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        return this.contents(object).indexOf(object2);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.c.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.c.remove(treeModelListener);
    }

    protected boolean isRoot(Object object) {
        return object != null && this.a().equivalent(this.getRoot(), object);
    }

    protected boolean isTreeNode(Object object) {
        Object object2 = object;
        while (object2 != null) {
            if (this.isRoot(object2)) {
                return true;
            }
            object2 = this.getParentNode(object2);
        }
        return false;
    }

    protected Collection<?> getChildren(Object object) {
        return this.contentProvider.getChildren(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Object> contents(Object object) {
        while (this.contentProvider != null) {
            Object object2;
            Object object3 = this.d;
            synchronized (object3) {
                object2 = this.d.get(object);
                if (object2 != null) {
                    return object2;
                }
            }
            object3 = this.a(this.getChildren(object));
            object2 = this.d;
            synchronized (object2) {
                if (this.d.putIfAbsent(object, (List<Object>)object3) == null) {
                    return object3;
                }
            }
        }
        return Collections.emptyList();
    }

    protected void updateLabel(Object object) {
        if (!this.isTreeNode(object)) {
            return;
        }
        if (this.isRoot(object)) {
            this.fireTreeNodesChanged(object, null, null);
        } else {
            Object object2 = this.getParentNode(object);
            int n = this.getIndexOfChild(object2, object);
            if (n >= 0) {
                int[] nArray = new int[]{n};
                Object[] objectArray = new Object[]{object};
                this.fireTreeNodesChanged(object2, nArray, objectArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshContent(Object object2) {
        List list;
        int[] nArray;
        List list2;
        int[] nArray2;
        Map<Object, List<Object>> map = this.d;
        synchronized (map) {
            List list3 = this.a(object2, false);
            if (list3 == null || !this.isTreeNode(object2)) {
                return;
            }
            List<Object> list4 = this.contents(object2);
            Equivalence<Object> equivalence = this.a();
            nArray2 = MoreLists.differenceOf(list3, list4, equivalence);
            list2 = MoreLists.getAll(list3, (int[])nArray2);
            if (nArray2.length > 0) {
                list2.forEach(object -> this.a(object, true));
                list3 = MoreLists.excludeAll(list3, (int[])nArray2);
            }
            nArray = MoreLists.differenceOf(list4, list3, equivalence);
            list = MoreLists.getAll(list4, (int[])nArray);
        }
        if (nArray2.length > 0) {
            this.fireTreeNodesRemoved(object2, nArray2, list2.toArray());
        }
        if (nArray.length > 0) {
            this.fireTreeNodesInserted(object2, nArray, list.toArray());
        }
    }

    protected void resetState() {
        this.d.clear();
    }

    protected void fireTreeNodesChanged(Object object, int[] nArray, Object[] objectArray) {
        TreePath treePath = this.getPath(object);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        a.trace(b, "treeNodesChanged: {}", (Object)treeModelEvent);
        for (TreeModelListener treeModelListener : this.c) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, int[] nArray, Object[] objectArray) {
        TreePath treePath = this.getPath(object);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        a.trace(b, "treeNodesInserted: {}", (Object)treeModelEvent);
        for (TreeModelListener treeModelListener : this.c) {
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, int[] nArray, Object[] objectArray) {
        TreePath treePath = this.getPath(object);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        a.trace(b, "treeNodesRemoved: {}", (Object)treeModelEvent);
        for (TreeModelListener treeModelListener : this.c) {
            treeModelListener.treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, int[] nArray, Object[] objectArray) {
        TreePath treePath = this.getPath(object);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        a.trace(b, "treeStructureChanged: {}", (Object)treeModelEvent);
        for (TreeModelListener treeModelListener : this.c) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    protected boolean useEquals() {
        return false;
    }

    Equivalence<Object> a() {
        return this.useEquals() ? Equivalence.equals() : Equivalence.identity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Object> a(Object object, boolean bl) {
        Map<Object, List<Object>> map = this.d;
        synchronized (map) {
            List<Object> list = this.d.remove(object);
            if (list == null || list.isEmpty() || !bl) {
                return list;
            }
            ArrayDeque<List<Object>> arrayDeque = new ArrayDeque<List<Object>>();
            arrayDeque.offer(list);
            do {
                for (Object e : (List)arrayDeque.remove()) {
                    List<Object> list2 = this.d.remove(e);
                    if (list2 == null || list2.isEmpty()) continue;
                    arrayDeque.offer(list2);
                }
            } while (!arrayDeque.isEmpty());
            return list;
        }
    }

    List<Object> a(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.useEquals()) {
            return new ArrayList<Object>(collection);
        }
        return new BasicEList.FastCompare(collection);
    }
}

