/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.astah.common.collect.MoreLists;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.widget.swing.ContentTableModel;
import net.astah.golf.widget.swing.IInputProvider;
import net.astah.golf.widget.swing.IStructuredContentProvider;
import net.astah.golf.widget.swing.IStructuredViewerAdapter;
import net.astah.golf.widget.swing.IViewerAdapter;
import net.astah.jomt.jview.TextAwareTableModel;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.edit.provider.IDisposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ContentProviderTableModel
implements ContentTableModel,
IStructuredViewerAdapter,
TextAwareTableModel,
IDisposable {
    private static final Logger b = LoggerFactory.getLogger(ContentProviderTableModel.class);
    private static final Marker c = MarkerFactory.getMarker((String)"provider");
    private final List<TableModelListener> d = new CopyOnWriteArrayList<TableModelListener>();
    private final AtomicReference<List<Object>> e = new AtomicReference();
    protected IStructuredContentProvider contentProvider;
    protected IPropertySourceProvider propertySourceProvider;
    protected ITableColumnProvider columnProvider;
    protected Object input;

    public ContentProviderTableModel(IStructuredContentProvider iStructuredContentProvider, ITableColumnProvider iTableColumnProvider) {
        this(iStructuredContentProvider, (IPropertySourceProvider)iStructuredContentProvider, iTableColumnProvider);
    }

    public ContentProviderTableModel(IStructuredContentProvider iStructuredContentProvider, IPropertySourceProvider iPropertySourceProvider, ITableColumnProvider iTableColumnProvider) {
        this.contentProvider = iStructuredContentProvider;
        this.propertySourceProvider = iPropertySourceProvider;
        this.columnProvider = iTableColumnProvider;
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(IStructuredContentProvider iStructuredContentProvider) {
        if (this.contentProvider != null) {
            this.contentProvider.inputChanged(null, this.input, null);
        }
        if (iStructuredContentProvider != null && this.input != null) {
            iStructuredContentProvider.inputChanged((IViewerAdapter)this, null, this.input);
        }
        this.contentProvider = iStructuredContentProvider;
    }

    public IPropertySourceProvider getPropertySourceProvider() {
        return this.propertySourceProvider;
    }

    public void setPropertySourceProvider(IPropertySourceProvider iPropertySourceProvider) {
        this.propertySourceProvider = iPropertySourceProvider;
    }

    public ITableColumnProvider getColumnProvider() {
        return this.columnProvider;
    }

    public void setColumnProvider(ITableColumnProvider iTableColumnProvider) {
        this.columnProvider = iTableColumnProvider;
    }

    public void dispose() {
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
            this.contentProvider = null;
        }
        this.setInput(null);
    }

    public boolean isDisposed() {
        return this.d.isEmpty();
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object object) {
        Object object2 = this.input;
        if (!this.a().equivalent(object2, object)) {
            this.resetState();
            this.input = object;
            if (this.contentProvider != null) {
                this.contentProvider.inputChanged((IViewerAdapter)this, object2, object);
            }
        }
    }

    public void refresh() {
        this.resetState();
        this.fireTableChanged(0, Integer.MAX_VALUE, -1, 0);
    }

    public void refresh(Object object) {
        if (this.a().equivalent(this.getInput(), object)) {
            this.refreshContent();
        }
    }

    public void update(Object object) {
        this.updateLabel(object);
    }

    public int getRowCount() {
        return this.contents().size();
    }

    public int getColumnCount() {
        return this.columnProvider.getColumnDescriptors().size();
    }

    public String getColumnName(int n) {
        ITableColumnProvider.IColumnDescriptor iColumnDescriptor = this.getColumnDescriptor(n);
        return Objects.toString(iColumnDescriptor.getHeaderValue((IInputProvider)this), null);
    }

    public Class<?> getColumnClass(int n) {
        ITableColumnProvider.IColumnDescriptor iColumnDescriptor = this.getColumnDescriptor(n);
        return iColumnDescriptor.getColumnClass((IInputProvider)this);
    }

    public boolean isCellEditable(int n, int n2) {
        ITableColumnProvider.IColumnDescriptor iColumnDescriptor = this.getColumnDescriptor(n2);
        return iColumnDescriptor instanceof ITableColumnProvider.IEditableColumnDescriptor;
    }

    public Object getValueAt(int n, int n2) {
        Object object = this.getRowAt(n);
        ITableColumnProvider.IColumnDescriptor iColumnDescriptor = this.getColumnDescriptor(n2);
        return iColumnDescriptor.getColumnValue(this.propertySourceProvider, object);
    }

    public void setValueAt(Object object, int n, int n2) {
        Object object2 = this.getRowAt(n);
        ITableColumnProvider.IColumnDescriptor iColumnDescriptor = this.getColumnDescriptor(n2);
        if (iColumnDescriptor instanceof ITableColumnProvider.IEditableColumnDescriptor) {
            ((ITableColumnProvider.IEditableColumnDescriptor)iColumnDescriptor).setColumnValue(this.propertySourceProvider, object2, object);
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.d.add(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.d.remove(tableModelListener);
    }

    public Object getRowAt(int n) {
        return n < this.contents().size() ? this.contents().get(n) : null;
    }

    public int getIndexOfRow(Object object) {
        return this.contents().indexOf(object);
    }

    public String getTextValueAt(int n, int n2) {
        Object object = this.getRowAt(n);
        ITableColumnProvider.IColumnDescriptor iColumnDescriptor = this.getColumnDescriptor(n2);
        return iColumnDescriptor.getColumnTextValue(this.propertySourceProvider, object);
    }

    protected void updateLabel(Object object) {
        int n;
        List<Object> list = this.e.get();
        if (list != null && (n = list.indexOf(object)) >= 0) {
            this.fireTableChanged(n, n, -1, 0);
        }
    }

    protected void refreshContent() {
        List<Object> list;
        List list2;
        do {
            if ((list2 = this.e.get()) != null) continue;
            return;
        } while (!this.e.compareAndSet(list2, list = this.a(this.getElements(this.getInput()))));
        Equivalence<Object> equivalence = this.a();
        int[] nArray = MoreLists.differenceOf(list2, list, equivalence);
        if (nArray.length > 0) {
            list2 = MoreLists.excludeAll(list2, (int[])nArray);
        }
        int[] nArray2 = MoreLists.differenceOf(list, (List)list2, equivalence);
        if (nArray.length > 0) {
            this.fireTableChanged(nArray, -1, -1);
        }
        if (nArray2.length > 0) {
            this.fireTableChanged(nArray2, -1, 1);
        }
    }

    protected void resetState() {
        this.e.set(null);
    }

    protected Collection<?> getElements(Object object) {
        return this.contentProvider.getElements(object);
    }

    protected List<Object> contents() {
        while (this.contentProvider != null) {
            List<Object> list = this.e.get();
            if (list != null) {
                return list;
            }
            list = this.a(this.getElements(this.getInput()));
            if (!this.e.compareAndSet(null, list)) continue;
            return list;
        }
        return Collections.emptyList();
    }

    protected ITableColumnProvider.IColumnDescriptor getColumnDescriptor(int n) {
        return (ITableColumnProvider.IColumnDescriptor)this.columnProvider.getColumnDescriptors().get(n);
    }

    protected void fireTableChanged(int[] nArray, int n, int n2) {
        int n3;
        assert (nArray.length > 0);
        int n4 = n3 = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            int n5 = nArray[i];
            if (this.getRowCount() < n5) break;
            if (n4 + 1 != n5) {
                this.fireTableChanged(n3, n4, n, n2);
                n3 = n5;
            }
            n4 = n5;
        }
        this.fireTableChanged(n3, n4, n, n2);
    }

    protected void fireTableChanged(int n, int n2, int n3, int n4) {
        TableModelEvent tableModelEvent = new TableModelEvent((TableModel)((Object)this), n, n2, n3, n4);
        if (b.isTraceEnabled(c)) {
            b.trace(c, "tableChanged: {}", ContentProviderTableModel.a(tableModelEvent));
        }
        for (TableModelListener tableModelListener : this.d) {
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    protected boolean useEquals() {
        return false;
    }

    Equivalence<Object> a() {
        return this.useEquals() ? Equivalence.equals() : Equivalence.identity();
    }

    List<Object> a(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.useEquals()) {
            return new ArrayList<Object>(collection);
        }
        return new BasicEList.FastCompare(collection);
    }

    private static Object a(TableModelEvent tableModelEvent) {
        return MoreObjects.toStringHelper((Object)tableModelEvent).add("source", tableModelEvent.getSource()).add("firstRow", (Object)ContentProviderTableModel.a(tableModelEvent.getFirstRow())).add("lastRow", (Object)ContentProviderTableModel.a(tableModelEvent.getLastRow())).add("column", (Object)ContentProviderTableModel.b(tableModelEvent.getColumn())).add("type", (Object)ContentProviderTableModel.c(tableModelEvent.getType()));
    }

    private static String a(int n) {
        return n == -1 ? "HEADER_ROW" : String.valueOf(n);
    }

    private static String b(int n) {
        return n == -1 ? "ALL_COLUMNS" : String.valueOf(n);
    }

    private static String c(int n) {
        switch (n) {
            case 0: {
                return "UPDATE";
            }
            case 1: {
                return "INSERT";
            }
            case -1: {
                return "DELETE";
            }
        }
        return String.valueOf(n);
    }
}

