/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import net.astah.emf.edit.provider.swing.b;
import org.eclipse.emf.edit.provider.ComposedImage;

public class ComposedIcon
implements Icon {
    protected final int width;
    protected final int height;
    protected final Icon[] icons;
    protected final ComposedImage.Point[] drawPoints;

    ComposedIcon(int n, int n2, List<Icon> list, List<ComposedImage.Point> list2) {
        assert (list.size() <= list2.size());
        this.width = n;
        this.height = n2;
        this.icons = list.toArray(new Icon[list.size()]);
        this.drawPoints = list2.toArray(new ComposedImage.Point[list2.size()]);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics graphics2 = graphics.create(n, n2, this.getIconWidth(), this.getIconHeight());
        int n3 = this.icons.length;
        for (int i = 0; i < n3; ++i) {
            Icon icon = this.icons[i];
            ComposedImage.Point point = this.drawPoints[i];
            icon.paintIcon(component, graphics2, point.x, point.y);
        }
        graphics2.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public static class Builder {
        protected final List<Icon> icons = new ArrayList<Icon>();
        protected final List<ComposedImage.Point> drawPoints = new ArrayList<ComposedImage.Point>();

        private Builder() {
        }

        public Builder add(Icon icon) {
            return this.add(icon, 0, 0);
        }

        public Builder add(Icon icon, int n, int n2) {
            ComposedImage.Point point = new ComposedImage.Point();
            point.x = n;
            point.y = n2;
            this.icons.add(icon);
            this.drawPoints.add(point);
            return this;
        }

        public Icon build() {
            ComposedImage.Point point;
            int n;
            int n2 = this.drawPoints.size();
            if (n2 == 1) {
                return this.icons.get(0);
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (n = 0; n < n2; ++n) {
                point = this.drawPoints.get(n);
                n3 = Math.min(n3, point.x);
                n4 = Math.min(n4, point.y);
            }
            for (n = 0; n < n2; ++n) {
                point = this.drawPoints.get(n);
                point.x -= n3;
                point.y -= n4;
                Icon icon = this.icons.get(n);
                n5 = Math.max(n5, point.x + icon.getIconWidth());
                n6 = Math.max(n6, point.y + icon.getIconHeight());
            }
            return new ComposedIcon(n5, n6, this.icons, this.drawPoints);
        }

        /* synthetic */ Builder(b b2) {
            this();
        }
    }
}

