/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.awt.Color;
import java.text.MessageFormat;
import org.eclipse.emf.common.util.URI;

public class ColorURIResolver {
    private final Color a;
    private final Color b;
    private transient float[] c;

    public ColorURIResolver(Color color, Color color2) {
        this.a = color;
        this.b = color2;
    }

    public Color resolve(URI uRI) {
        if ("color".equalsIgnoreCase(uRI.scheme()) && uRI.hasAuthority()) {
            switch (uRI.authority()) {
                case "rgb": {
                    return this.a(uRI);
                }
                case "rgba": {
                    return this.b(uRI);
                }
                case "hsb": {
                    return this.c(uRI);
                }
            }
        }
        throw new IllegalArgumentException("Unexpected color scheme: " + uRI);
    }

    Color a(URI uRI) {
        if (uRI.segmentCount() != 3) {
            throw new IllegalArgumentException("The RGB URI requires 3 segments: " + uRI);
        }
        try {
            int n = this.a(uRI, 0, 0, 255);
            int n2 = this.a(uRI, 1, 0, 255);
            int n3 = this.a(uRI, 2, 0, 255);
            return new Color(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal RGB uri: " + uRI, numberFormatException);
        }
    }

    Color b(URI uRI) {
        if (uRI.segmentCount() != 4) {
            throw new IllegalArgumentException("The RGBA URI requires 4 segments: " + uRI);
        }
        try {
            int n = this.a(uRI, 0, 0, 255);
            int n2 = this.a(uRI, 1, 0, 255);
            int n3 = this.a(uRI, 2, 0, 255);
            int n4 = this.a(uRI, 3, 0, 255);
            return new Color(n, n2, n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal RGB uri: " + uRI, numberFormatException);
        }
    }

    Color c(URI uRI) {
        try {
            float f = this.a(uRI, 0, 0.0f, 360.0f);
            float f2 = this.a(uRI, 1, 0.0f, 1.0f);
            float f3 = this.a(uRI, 2, 0.0f, 1.0f);
            return Color.getHSBColor(f, f2, f3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal HSB uri: " + uRI, numberFormatException);
        }
    }

    int a(URI uRI, int n, int n2, int n3) {
        String string = uRI.segment(n);
        int n4 = Integer.parseInt(string);
        if (n4 < n2 || n4 > n3) {
            String string2 = "A color component ''{0}'' is out of range : {1}";
            throw new IllegalArgumentException(MessageFormat.format("A color component ''{0}'' is out of range : {1}", string, uRI));
        }
        return n4;
    }

    float a(URI uRI, int n, float f, float f2) {
        String string = uRI.segmentCount() >= n ? uRI.segment(n) : "";
        Color color = this.a(uRI, string);
        if (color != null) {
            return this.a(color, n);
        }
        float f3 = Float.parseFloat(string);
        if (f3 < f || f3 > f2) {
            String string2 = "A color component ''{0}'' is out of range : {1}";
            throw new IllegalArgumentException(MessageFormat.format("A color component ''{0}'' is out of range : {1}", string, uRI));
        }
        return f3;
    }

    Color a(URI uRI, String string) {
        if (string.isEmpty() || "foreground".equalsIgnoreCase(string)) {
            if (this.a == null) {
                throw new IllegalArgumentException("The URI requires foreground color: " + uRI);
            }
            return this.a;
        }
        if ("background".equalsIgnoreCase(string)) {
            if (this.b == null) {
                throw new IllegalArgumentException("The URI requires background color: " + uRI);
            }
            return this.b;
        }
        return null;
    }

    float a(Color color, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        this.c = Color.RGBtoHSB(n2, n3, n4, this.c);
        return this.c[n];
    }
}

