/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.ColorURIResolver;
import net.astah.emf.edit.provider.swing.FontURIResolver;
import net.astah.golf.view.swing.IStyledLabelProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.StyledString;

public class AdapterFactoryStyledLabelProvider
implements IStyledLabelProvider {
    private final AdapterFactory a;
    private final StyleContext b;
    private final ColorURIResolver c = new ColorURIResolver(null, null);

    public AdapterFactoryStyledLabelProvider(AdapterFactory adapterFactory) {
        this.a = adapterFactory;
        this.b = new StyleContext();
    }

    public StyledDocument getStyledText(Object object) {
        IItemStyledLabelProvider iItemStyledLabelProvider = ItemProviders.adapt(this.a, object, IItemStyledLabelProvider.class);
        if (iItemStyledLabelProvider != null) {
            Object object2 = iItemStyledLabelProvider.getStyledText(object);
            if (object2 == null) {
                return null;
            }
            if (object2 instanceof String) {
                object2 = new StyledString((String)object2);
            }
            return this.a((StyledString)object2, this.b);
        }
        return null;
    }

    private StyledDocument a(StyledString styledString, StyleContext styleContext) {
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument(styleContext);
        for (StyledString.Fragment fragment : styledString) {
            String string = fragment.getString();
            String string2 = this.a(fragment.getStyle());
            Style style = styleContext.getStyle(string2) != null ? styleContext.getStyle(string2) : this.a(styleContext, fragment.getStyle());
            try {
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), string, style);
                defaultStyledDocument.setLogicalStyle(0, style);
            }
            catch (BadLocationException badLocationException) {
                return defaultStyledDocument;
            }
        }
        return defaultStyledDocument;
    }

    private Style a(StyleContext styleContext, StyledString.Style style) {
        Style style2 = styleContext.addStyle(this.a(style), styleContext.getStyle("default"));
        if (style.getForegroundColor() != null) {
            StyleConstants.setForeground(style2, this.a(style.getForegroundColor()));
        }
        if (style.getBackgoundColor() != null) {
            StyleConstants.setBackground(style2, this.a(style.getBackgoundColor()));
        }
        if (style.getFont() != null) {
            Font font = new FontURIResolver(null).resolve(style.getFont());
            StyleConstants.setFontFamily(style2, font.getFamily());
            StyleConstants.setFontSize(style2, font.getSize());
        }
        return style2;
    }

    private Color a(URI uRI) {
        return this.c.resolve(uRI);
    }

    private String a(StyledString.Style style) {
        return "" + Objects.hash(style.getBackgoundColor(), style.getBorderColor(), style.getBorderStyle(), style.getFont(), style.getForegroundColor(), style.getStrikeoutColor(), style.getUnderlineColor(), style.getUnderlineStyle(), style.isStrikedout());
    }
}

