/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import java.awt.Color;
import java.awt.Font;
import java.util.MissingResourceException;
import java.util.Objects;
import javax.swing.Icon;
import net.astah.emf.edit.provider.swing.ColorURIResolver;
import net.astah.emf.edit.provider.swing.FontURIResolver;
import net.astah.golf.widget.BaseLabelProvider;
import net.astah.golf.widget.IBaseLabelProvider;
import net.astah.golf.widget.LabelProviderChangedEvent;
import net.astah.golf.widget.swing.IColorProvider;
import net.astah.golf.widget.swing.IFontProvider;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.SwingIconRegistry;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IUpdateableItemText;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AdapterFactoryLabelProvider
extends BaseLabelProvider
implements IColorProvider.Relative,
IFontProvider.Relative,
ILabelProvider,
IDisposable,
INotifyChangedListener {
    private static final Logger a = LoggerFactory.getLogger(AdapterFactoryLabelProvider.class);
    private static final Marker b = MarkerFactory.getMarker((String)"provider");
    protected AdapterFactory adapterFactory;
    protected Font currentFont;
    protected Color currentForeground;
    protected Color currentBackground;
    protected boolean isFireLabelUpdateNotifications;

    public AdapterFactoryLabelProvider(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.adapterFactory = adapterFactory;
    }

    public void dispose() {
        super.dispose();
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
    }

    public Font getCurrentFont() {
        return this.currentFont;
    }

    public void setCurrentFont(Font font) {
        this.currentFont = font;
    }

    public Color getCurrentForeground() {
        return this.currentForeground;
    }

    public void setCurrentForeground(Color color) {
        this.currentForeground = color;
    }

    public Color getCurrentBackground() {
        return this.currentBackground;
    }

    public void setCurrentBackground(Color color) {
        this.currentBackground = color;
    }

    public String getText(Object object) {
        String string;
        String string2;
        Object object2 = this.adapterFactory.adapt(object, IItemLabelProvider.class);
        if (object2 instanceof IItemLabelProvider && (string2 = this.getText((IItemLabelProvider)object2, object)) != null && (string = this.resolveText(string2)) != null) {
            return string;
        }
        return Objects.toString(object, null);
    }

    public Icon getImage(Object object) {
        Icon icon;
        Object object2;
        Object object3 = this.adapterFactory.adapt(object, IItemLabelProvider.class);
        if (object3 instanceof IItemLabelProvider && (object2 = this.getImage((IItemLabelProvider)object3, object)) != null && (icon = this.resolveImage(object2)) != null) {
            return icon;
        }
        return null;
    }

    public Color getForeground(Object object) {
        Color color;
        Object object2;
        Object object3 = this.adapterFactory.adapt(object, IItemColorProvider.class);
        if (object3 instanceof IItemColorProvider && (object2 = this.getForeground((IItemColorProvider)object3, object)) != null && (color = this.resolveColor(object2)) != null) {
            return color;
        }
        return this.getCurrentForeground();
    }

    public Color getBackground(Object object) {
        Color color;
        Object object2;
        Object object3 = this.adapterFactory.adapt(object, IItemColorProvider.class);
        if (object3 instanceof IItemColorProvider && (object2 = this.getBackground((IItemColorProvider)object3, object)) != null && (color = this.resolveColor(object2)) != null) {
            return color;
        }
        return this.getCurrentBackground();
    }

    public Font getFont(Object object) {
        Font font;
        Object object2;
        Object object3 = this.adapterFactory.adapt(object, IItemFontProvider.class);
        if (object3 instanceof IItemFontProvider && (object2 = this.getFont((IItemFontProvider)object3, object)) != null && (font = this.resolveFont(object2)) != null) {
            return font;
        }
        return this.getCurrentFont();
    }

    public boolean isFireLabelUpdateNotifications() {
        return this.isFireLabelUpdateNotifications;
    }

    public void setFireLabelUpdateNotifications(boolean bl) {
        this.isFireLabelUpdateNotifications = bl;
    }

    public void fireLabelProviderChanged() {
        LabelProviderChangedEvent labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        this.fireLabelProviderChanged(labelProviderChangedEvent);
    }

    public void notifyChanged(Notification notification) {
        if (this.isFireLabelUpdateNotifications() && (!(notification instanceof IViewerNotification) || ((IViewerNotification)notification).isLabelUpdate())) {
            LabelProviderChangedEvent labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, notification.getNotifier());
            this.fireLabelProviderChanged(labelProviderChangedEvent);
        }
    }

    protected String getText(IItemLabelProvider iItemLabelProvider, Object object) {
        try {
            return iItemLabelProvider.getText(object);
        }
        catch (RuntimeException runtimeException) {
            a.warn(b, "Failed to get text for " + object, (Throwable)runtimeException);
            return null;
        }
    }

    protected Object getImage(IItemLabelProvider iItemLabelProvider, Object object) {
        try {
            return iItemLabelProvider.getImage(object);
        }
        catch (MissingResourceException missingResourceException) {
            a.warn(b, "Failed to get image: {}", (Object)missingResourceException.getMessage());
            return ((Object)((Object)this)).getClass().getResource("/icons/full/obj16/missing_obj.png");
        }
        catch (RuntimeException runtimeException) {
            a.error(b, "Failed to get image for " + object, (Throwable)runtimeException);
            return null;
        }
    }

    protected String getUpdateableText(IUpdateableItemText iUpdateableItemText, Object object) {
        try {
            return iUpdateableItemText.getUpdateableText(object);
        }
        catch (RuntimeException runtimeException) {
            a.warn(b, "Failed to get updateable text for " + object, (Throwable)runtimeException);
            return null;
        }
    }

    protected void setText(IUpdateableItemText iUpdateableItemText, Object object, String string) {
        try {
            iUpdateableItemText.setText(object, string);
        }
        catch (RuntimeException runtimeException) {
            a.warn(b, "Failed to set text of " + object, (Throwable)runtimeException);
        }
    }

    protected Object getForeground(IItemColorProvider iItemColorProvider, Object object) {
        try {
            return iItemColorProvider.getForeground(object);
        }
        catch (RuntimeException runtimeException) {
            a.warn(b, "Failed to get foreground color for " + object, (Throwable)runtimeException);
            return null;
        }
    }

    protected Object getBackground(IItemColorProvider iItemColorProvider, Object object) {
        try {
            return iItemColorProvider.getBackground(object);
        }
        catch (RuntimeException runtimeException) {
            a.warn(b, "Failed to get background color for " + object, (Throwable)runtimeException);
            return null;
        }
    }

    protected Object getFont(IItemFontProvider iItemFontProvider, Object object) {
        try {
            return iItemFontProvider.getFont(object);
        }
        catch (RuntimeException runtimeException) {
            a.warn(b, "Failed to get font for " + object, (Throwable)runtimeException);
            return null;
        }
    }

    protected String resolveText(String string) {
        return string;
    }

    protected Icon resolveImage(Object object) {
        return SwingIconRegistry.INSTANCE.getIcon(object);
    }

    protected String resolveUpdateableText(String string) {
        return string;
    }

    protected Color resolveColor(Object object) {
        if (object instanceof URI) {
            return this.a((URI)object);
        }
        if (object instanceof Color) {
            return (Color)object;
        }
        return null;
    }

    Color a(URI uRI) {
        return new ColorURIResolver(this.getCurrentForeground(), this.getCurrentBackground()).resolve(uRI);
    }

    protected Font resolveFont(Object object) {
        if (object instanceof URI) {
            return this.b((URI)object);
        }
        if (object instanceof Font) {
            return (Font)object;
        }
        return null;
    }

    Font b(URI uRI) {
        return new FontURIResolver(this.getCurrentFont()).resolve(uRI);
    }
}

