/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.swing;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import net.astah.emf.edit.notify.ViewerNotificationQueue;
import net.astah.emf.edit.provider.swing.PropertyEditorFactory;
import net.astah.emf.edit.provider.swing.PropertySource;
import net.astah.golf.view.swing.IPropertySource;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.widget.swing.IStructuredViewerAdapter;
import net.astah.golf.widget.swing.ITreeContentProvider;
import net.astah.golf.widget.swing.IViewerAdapter;
import net.astah.jomt.jutil.SwingInvoker;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IViewerNotification;

public class AdapterFactoryContentProvider
implements IPropertySourceProvider,
ITreeContentProvider,
INotifyChangedListener {
    protected AdapterFactory adapterFactory;
    protected PropertyEditorFactory.Registry propertyEditorFactoryRegistry;
    protected IViewerAdapter viewer;
    protected RefreshQueue queue;

    public AdapterFactoryContentProvider(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.queue = this.createQueue();
        Objects.requireNonNull(this.queue, "queue");
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.adapterFactory = adapterFactory;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public PropertyEditorFactory.Registry getPropertyEditorFactoryRegistry() {
        return this.propertyEditorFactoryRegistry;
    }

    public void setPropertyEditorFactoryRegistry(PropertyEditorFactory.Registry registry) {
        this.propertyEditorFactoryRegistry = registry;
    }

    public void inputChanged(IViewerAdapter iViewerAdapter, Object object, Object object2) {
        this.viewer = iViewerAdapter;
    }

    public Collection<?> getElements(Object object) {
        Object object2 = this.adapterFactory.adapt(object, IStructuredItemContentProvider.class);
        if (object2 instanceof IStructuredItemContentProvider) {
            IStructuredItemContentProvider iStructuredItemContentProvider = (IStructuredItemContentProvider)object2;
            return iStructuredItemContentProvider.getElements(object);
        }
        return Collections.emptyList();
    }

    public Collection<?> getChildren(Object object) {
        Object object2 = this.adapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (object2 instanceof ITreeItemContentProvider) {
            ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)object2;
            return iTreeItemContentProvider.getChildren(object);
        }
        return Collections.emptyList();
    }

    public Object getParent(Object object) {
        Object object2 = this.adapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (object2 instanceof ITreeItemContentProvider) {
            ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)object2;
            return iTreeItemContentProvider.getParent(object);
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        Object object2 = this.adapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (object2 instanceof ITreeItemContentProvider) {
            ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)object2;
            return iTreeItemContentProvider.hasChildren(object);
        }
        return false;
    }

    public IPropertySource getPropertySource(Object object) {
        Object object2;
        if (object instanceof IPropertySource) {
            return (IPropertySource)object;
        }
        Object object3 = object2 = object instanceof EObject && ((EObject)object).eClass() == null ? null : this.adapterFactory.adapt(object, IItemPropertySource.class);
        if (object2 instanceof IItemPropertySource) {
            return this.createPropertySource(object, (IItemPropertySource)object2);
        }
        return null;
    }

    protected IPropertySource createPropertySource(Object object, IItemPropertySource iItemPropertySource) {
        return new PropertySource(this.propertyEditorFactoryRegistry, object, iItemPropertySource);
    }

    public void dispose() {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
        this.viewer = null;
    }

    public void notifyChanged(Notification notification) {
        if (this.viewer != null && !this.viewer.isDisposed() && notification instanceof IViewerNotification && this.queue.offerAndWasEmpty((IViewerNotification)notification)) {
            this.asyncExec(this.queue);
        }
    }

    protected RefreshQueue createQueue() {
        return new RefreshQueue();
    }

    protected void asyncExec(Runnable runnable) {
        if (this.viewer instanceof Executor) {
            ((Executor)this.viewer).execute(runnable);
        } else {
            SwingInvoker.runLaterInEDT((Runnable)runnable);
        }
    }

    protected class RefreshQueue
    extends ViewerNotificationQueue
    implements Runnable {
        private static final long serialVersionUID = 1L;

        protected RefreshQueue() {
        }

        @Override
        public void run() {
            ArrayList<IViewerNotification> arrayList = new ArrayList<IViewerNotification>();
            if (this.drainTo(arrayList) > 0) {
                this.dispatch(arrayList);
            }
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("size", this.size()).toString();
        }

        protected void dispatch(List<IViewerNotification> list) {
            if (AdapterFactoryContentProvider.this.viewer instanceof IStructuredViewerAdapter) {
                IStructuredViewerAdapter iStructuredViewerAdapter = (IStructuredViewerAdapter)AdapterFactoryContentProvider.this.viewer;
                for (IViewerNotification iViewerNotification : list) {
                    Object object = iViewerNotification.getElement();
                    if (object != null) {
                        if (iViewerNotification.isLabelUpdate()) {
                            iStructuredViewerAdapter.update(object);
                        }
                        if (!iViewerNotification.isContentRefresh()) continue;
                        iStructuredViewerAdapter.refresh(object);
                        continue;
                    }
                    AdapterFactoryContentProvider.this.viewer.refresh();
                    break;
                }
            } else if (AdapterFactoryContentProvider.this.viewer != null) {
                AdapterFactoryContentProvider.this.viewer.refresh();
            }
        }
    }
}

