/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.decorator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.common.notify.EFeaturePathObserver;
import net.astah.emf.edit.notify.EFeaturePathAdapter;
import net.astah.emf.edit.provider.ContentDecorator;
import net.astah.emf.edit.provider.decorator.BasicContentDecoratorImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class MoveClassRule
extends BasicContentDecoratorImpl
implements EFeaturePathObserver.Listener {
    private final Map<EClass, Boolean> a = new IdentityHashMap<EClass, Boolean>();
    private final Map<EFeaturePathObserver, IDisposable> b = new IdentityHashMap<EFeaturePathObserver, IDisposable>();
    protected final EFeaturePath childrenPath;
    protected final EClass eParentClass;
    protected final EClass eMovingClass;

    protected MoveClassRule(EFeaturePath eFeaturePath, EClass eClass, EClass eClass2) {
        this.childrenPath = eFeaturePath;
        this.eParentClass = eClass;
        this.eMovingClass = eClass2;
    }

    public static ContentDecorator.Factory moveClass(EFeaturePath eFeaturePath) {
        return new FactoryImpl(eFeaturePath, null, null);
    }

    public static ContentDecorator.Factory moveClass(EFeaturePath eFeaturePath, EClass eClass, EClass eClass2) {
        return new FactoryImpl(eFeaturePath, eClass, eClass2);
    }

    @Override
    public Stream<?> getChildren(Object object, Stream<?> stream) {
        if (this.eParentClass.isInstance(object) && this.isTarget(object)) {
            EObject eObject = (EObject)object;
            this.observe(eObject);
            Set<EObject> set = this.a(eObject);
            if (!set.isEmpty()) {
                stream = MoveClassRule.a(stream, set.stream().filter(arg_0 -> ((EClass)this.eMovingClass).isInstance(arg_0)));
            }
        }
        if (stream != null && this.hasContainment(object)) {
            stream = stream.filter(object2 -> {
                Object object3 = this.getParent(object2, null);
                return object3 == null || object3 == object;
            });
        }
        return stream;
    }

    @Override
    public Object getParent(Object object, Object object2) {
        EObject eObject;
        if (this.eMovingClass.isInstance(object) && this.isTarget(object) && this.eParentClass.isInstance((Object)(eObject = this.b((EObject)object)))) {
            return eObject;
        }
        return object2;
    }

    public void pathChanged(EFeaturePathObserver.Event event) {
        for (EObject eObject : event.getAffectedObjects()) {
            if (!this.eParentClass.isInstance((Object)eObject)) continue;
            this.updateParent(eObject, event.getNotification());
        }
    }

    @Override
    public void dispose() {
        for (IDisposable iDisposable : Iterables.consumingIterable(this.b.values())) {
            iDisposable.dispose();
        }
        super.dispose();
    }

    @Override
    protected boolean isAppropriate(EClass eClass) {
        return EObjects.isSuperTypeOf((EClass)this.eParentClass, (EClass)eClass) || EObjects.isSuperTypeOf((EClass)this.eMovingClass, (EClass)eClass) || this.hasContainment(eClass);
    }

    protected boolean hasContainment(Object object) {
        if (object instanceof EObject) {
            EClass eClass = ((EObject)object).eClass();
            return this.hasContainment(eClass);
        }
        return object instanceof Resource;
    }

    protected boolean hasContainment(EClass eClass) {
        Boolean bl = this.a.get(eClass);
        if (bl != null) {
            return bl;
        }
        boolean bl2 = this.a(eClass, this.eMovingClass);
        this.a.putIfAbsent(eClass, bl2);
        return bl2;
    }

    @Override
    protected boolean isAppropriate(Class<?> clazz) {
        return Resource.class.isAssignableFrom(clazz);
    }

    protected void observe(EObject eObject) {
        EFeaturePathAdapter eFeaturePathAdapter = EFeaturePathAdapter.getFeaturePathAdapter((Notifier)eObject);
        if (eFeaturePathAdapter != null) {
            EFeaturePathObserver eFeaturePathObserver2 = eFeaturePathAdapter.getPropagator().getObserver();
            this.b.computeIfAbsent(eFeaturePathObserver2, eFeaturePathObserver -> eFeaturePathObserver.observe(this.childrenPath, (EFeaturePathObserver.Listener)this));
        }
    }

    protected void updateParent(EObject eObject, Notification notification) {
        ViewerNotification viewerNotification = new ViewerNotification(notification, (Object)eObject, true, false);
        this.changeNotifier.fireNotifyChanged((Notification)viewerNotification);
    }

    Set<EObject> a(EObject eObject) {
        Set set = (Set)this.childrenPath.getFirst().getReferences(eObject, null, LinkedHashSet::new);
        return this.childrenPath.castReferences(set);
    }

    EObject b(EObject eObject) {
        return this.childrenPath.getInverseReference(eObject);
    }

    boolean a(EClass eClass, EClass eClass2) {
        for (EReference eReference : eClass.getEAllContainments()) {
            EClass eClass3 = (EClass)eReference.getEType();
            if (!EObjects.isSuperTypeOf((EClass)eClass2, (EClass)eClass3) && !EObjects.isSuperTypeOf((EClass)eClass3, (EClass)eClass2)) continue;
            return true;
        }
        return false;
    }

    static Stream<?> a(Stream<?> stream, Stream<?> stream2) {
        if (stream == null) {
            return stream2;
        }
        if (stream2 == null) {
            return stream;
        }
        return Stream.concat(stream, stream2);
    }

    public static class FactoryImpl
    implements ContentDecorator.Factory {
        protected final EFeaturePath childrenPath;
        protected final EClass eParentClass;
        protected final EClass eMovingClass;

        public FactoryImpl(EFeaturePath eFeaturePath, EClass eClass, EClass eClass2) {
            this.a(eFeaturePath);
            this.childrenPath = eFeaturePath;
            this.eParentClass = (EClass)MoreObjects.firstNonNull((Object)eClass, (Object)eFeaturePath.getEClass());
            this.eMovingClass = (EClass)MoreObjects.firstNonNull((Object)eClass2, (Object)((EClass)eFeaturePath.getEType()));
        }

        @Override
        public ContentDecorator createContentDecorator() {
            return new MoveClassRule(this.childrenPath, this.eParentClass, this.eMovingClass);
        }

        void a(EFeaturePath eFeaturePath) {
            Objects.requireNonNull(eFeaturePath, "childrenPath");
            if (eFeaturePath.isInclusive()) {
                throw new IllegalArgumentException("childrenPath: must not be inclusive");
            }
            if (eFeaturePath.isInverseMany(false)) {
                throw new IllegalArgumentException("childrenPath: must not be inverse many");
            }
            EStructuralFeature eStructuralFeature = eFeaturePath.getLast().getFeature();
            if (!(eStructuralFeature instanceof EReference)) {
                throw new IllegalArgumentException("childrenPath: last segment must be reference");
            }
        }
    }
}

