/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.decorator;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.provider.ContentDecorator;
import net.astah.emf.edit.provider.decorator.BasicContentDecoratorImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IViewerNotification;

public class FilterRule
extends BasicContentDecoratorImpl {
    protected final EClass eClass;
    protected final Predicate<Object> predicate;

    protected FilterRule(EClass eClass, Predicate<Object> predicate) {
        this.eClass = eClass;
        this.predicate = predicate;
    }

    public static <T> ContentDecorator.Factory exclude(EClass eClass, Class<T> clazz, Predicate<T> predicate) {
        return new FactoryImpl(eClass, FilterRule.a(clazz, predicate).negate());
    }

    public static <T> ContentDecorator.Factory excludeTypeOf(EClass eClass, Collection<EClass> collection) {
        return new FactoryImpl(eClass, FilterRule.a(collection).negate());
    }

    public static <T> ContentDecorator.Factory excludeKindOf(EClass eClass, Collection<EClass> collection) {
        return new FactoryImpl(eClass, FilterRule.b(collection).negate());
    }

    public static <T> ContentDecorator.Factory include(EClass eClass, Class<T> clazz, Predicate<T> predicate) {
        return new FactoryImpl(eClass, FilterRule.a(clazz, predicate));
    }

    public static <T> ContentDecorator.Factory includeTypeOf(EClass eClass, Collection<EClass> collection) {
        return new FactoryImpl(eClass, FilterRule.a(collection));
    }

    public static <T> ContentDecorator.Factory includeKindOf(EClass eClass, Collection<EClass> collection) {
        return new FactoryImpl(eClass, FilterRule.b(collection));
    }

    static <T> Predicate<Object> a(Class<T> clazz, Predicate<T> predicate) {
        return object -> clazz.isInstance(object) && predicate.test(clazz.cast(object));
    }

    static Predicate<Object> a(Collection<EClass> collection) {
        return object -> object instanceof EObject && collection.contains(((EObject)object).eClass());
    }

    static Predicate<Object> b(Collection<EClass> collection) {
        return object -> collection.stream().anyMatch(eClass -> eClass.isInstance(object));
    }

    @Override
    public boolean isAppropriate(EClass eClass) {
        return EObjects.isSuperTypeOf((EClass)this.eClass, (EClass)eClass);
    }

    @Override
    public Stream<?> getChildren(Object object, Stream<?> stream) {
        if (stream != null && this.eClass.isInstance(object) && this.isTarget(object)) {
            return stream.filter(this.predicate);
        }
        return stream;
    }

    @Override
    public Object getParent(Object object, Object object2) {
        return object2;
    }

    @Override
    public boolean notifyChanged(IViewerNotification iViewerNotification) {
        if (iViewerNotification.isContentRefresh()) {
            switch (iViewerNotification.getEventType()) {
                case 3: {
                    return this.a(iViewerNotification.getNewValue());
                }
                case 5: {
                    for (Object e : (Collection)iViewerNotification.getNewValue()) {
                        if (this.a(e)) continue;
                        return false;
                    }
                    return true;
                }
                case 4: {
                    return this.a(iViewerNotification.getOldValue());
                }
                case 6: {
                    for (Object e : (Collection)iViewerNotification.getOldValue()) {
                        if (this.a(e)) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return super.notifyChanged(iViewerNotification);
    }

    private boolean a(Object object) {
        return this.isTarget(object) && !this.predicate.test(object);
    }

    public static class FactoryImpl
    implements ContentDecorator.Factory {
        protected final EClass eClass;
        protected final Predicate<Object> predicate;

        public FactoryImpl(EClass eClass, Predicate<Object> predicate) {
            Objects.requireNonNull(eClass, "eClass");
            Objects.requireNonNull(predicate, "predicate");
            this.eClass = eClass;
            this.predicate = predicate;
        }

        @Override
        public ContentDecorator createContentDecorator() {
            return new FilterRule(this.eClass, this.predicate);
        }
    }
}

