/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.decorator;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.astah.emf.edit.provider.ContentDecorator;

public class ContentDecoratorRegistryImpl
extends AbstractCollection<ContentDecorator.Factory>
implements ContentDecorator.Registry {
    protected final List<a> entries = new ArrayList<a>();
    protected final String provider;
    protected final List<ContentDecorator.Factory.Descriptor> descriptors = new ArrayList<ContentDecorator.Factory.Descriptor>();
    protected final List<ContentDecorator.Factory.Descriptor> appliedDescriptors = new ArrayList<ContentDecorator.Factory.Descriptor>();

    public ContentDecoratorRegistryImpl() {
        this.provider = null;
    }

    public ContentDecoratorRegistryImpl(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("provider");
        }
        this.provider = string;
    }

    @Override
    public Iterator<ContentDecorator.Factory> iterator() {
        return this.entries.stream().map(a2 -> a2.a).iterator();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean addDecorator(ContentDecorator.Factory factory, int n) {
        Objects.requireNonNull(factory, "factory");
        int n2 = 0;
        ListIterator<a> listIterator = this.entries.listIterator();
        while (listIterator.hasNext()) {
            a a2 = listIterator.next();
            if (factory.equals(a2.a)) {
                return false;
            }
            if (n < a2.b) continue;
            n2 = listIterator.nextIndex();
        }
        this.entries.add(n2, new a(factory, n));
        return true;
    }

    @Override
    public boolean removeDecorator(ContentDecorator.Factory factory) {
        Iterator<a> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            a a2 = iterator.next();
            if (!a2.a.equals(factory)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void addDescriptor(@NonNull ContentDecorator.Factory.Descriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.descriptors.add(descriptor);
    }

    public List<ContentDecorator.Factory.Descriptor> getDescriptors() {
        return Collections.unmodifiableList(this.descriptors);
    }

    @Override
    public List<ContentDecorator.Factory> decoratorsFor(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("target");
        }
        for (ContentDecorator.Factory.Descriptor descriptor : this.descriptors) {
            if (this.appliedDescriptors.contains(descriptor) || !descriptor.isApplicable(object)) continue;
            descriptor.registerTo(this);
            this.appliedDescriptors.add(descriptor);
        }
        return this.entries.stream().map(a2 -> a2.a).collect(Collectors.toList());
    }

    static class a {
        final ContentDecorator.Factory a;
        final int b;

        protected a(ContentDecorator.Factory factory, int n) {
            Objects.requireNonNull(factory, "factory");
            this.a = factory;
            this.b = n;
        }
    }
}

