/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider.decorator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import net.astah.emf.edit.provider.ContentDecorator;
import net.astah.emf.edit.provider.decorator.ContentDecoratorFactory;
import net.astah.emf.edit.provider.decorator.FilterRule;
import org.eclipse.emf.ecore.EClass;

public abstract class BasicContentDecoratorFactoryImpl
implements ContentDecoratorFactory {
    @Override
    public void prepareDecoratorRegistry(@NonNull ContentDecorator.Registry registry) {
        if (registry == null) {
            throw new NullPointerException("registry");
        }
        this.addContentDecorators(registry);
        this.addFilteringDecorators(registry);
        this.addOrderingDecorators(registry);
    }

    protected void addContentDecorators(ContentDecorator.Registry registry) {
    }

    protected void addFilteringDecorators(ContentDecorator.Registry registry) {
        this.prepareExcludeTypeOf().forEach((eClass, set) -> registry.addDecorator(FilterRule.excludeTypeOf(eClass, set), Priority.FILTER.value()));
        this.prepareExcludeKindOf().forEach((eClass, set) -> registry.addDecorator(FilterRule.excludeKindOf(eClass, set), Priority.FILTER.value()));
    }

    protected void addOrderingDecorators(ContentDecorator.Registry registry) {
    }

    protected Map<EClass, Set<EClass>> prepareExcludeTypeOf() {
        return new HashMap<EClass, Set<EClass>>();
    }

    protected Map<EClass, Set<EClass>> prepareExcludeKindOf() {
        return new HashMap<EClass, Set<EClass>>();
    }

    protected <K, E> Map<K, Set<E>> addValues(Map<K, Set<E>> map, K k, Collection<E> collection) {
        map.computeIfAbsent(k, object -> new HashSet()).addAll(collection);
        return map;
    }

    public static enum Priority {
        ADD,
        FILTER,
        ORDER;


        public int value() {
            return this.ordinal();
        }
    }
}

