/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;

public abstract class Variant {
    public static final String VARIANT_SCHEME = "variant";
    private static Queue<Function<URI, Variant>> a = new ConcurrentLinkedQueue<Function<URI, Variant>>();

    public static URI variantURI(Object object) {
        String string;
        if (object instanceof String && (string = (String)object).startsWith(VARIANT_SCHEME)) {
            try {
                return URI.createURI((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Variant resolve(URI uRI) {
        if (Variant.isApplicable(uRI)) {
            for (Function function : a) {
                Variant variant = (Variant)function.apply(uRI);
                if (variant == null) continue;
                return variant;
            }
        }
        return null;
    }

    public abstract String unwrapPropertyID(URI var1);

    public abstract URI wrapPropertyID(String var1);

    protected static boolean isApplicable(URI uRI) {
        return uRI.isHierarchical() && VARIANT_SCHEME.equalsIgnoreCase(uRI.scheme());
    }

    protected URI toURI(String string, String ... stringArray) {
        return URI.createHierarchicalURI((String)VARIANT_SCHEME, (String)string, null, (String[])stringArray, null, null);
    }

    protected static void register(Function<URI, Variant> function) {
        a.offer(function);
    }
}

