/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import net.astah.emf.edit.provider.Variant;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WeakInterningHashSet;

public class LocalizedVariant
extends Variant {
    private static final WeakInterningHashSet<LocalizedVariant> a;
    private final Locale b;

    private LocalizedVariant(Locale locale) {
        this.b = Objects.requireNonNull(locale, "locale");
    }

    public static LocalizedVariant of(Locale locale) {
        return (LocalizedVariant)a.intern((Object)new LocalizedVariant(locale));
    }

    @Override
    public URI wrapPropertyID(String string) {
        return this.toURI("localized", this.b.toLanguageTag(), string);
    }

    @Override
    public String unwrapPropertyID(URI uRI) {
        Preconditions.checkArgument((boolean)LocalizedVariant.isApplicable(uRI), (Object)"URI must be localized variant");
        return uRI.segmentCount() > 1 ? uRI.segment(1) : null;
    }

    public Locale getLocale() {
        return this.b;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("locale", (Object)this.b).toString();
    }

    static {
        LocalizedVariant.register(uRI -> {
            if ("alias".equals(uRI.authority())) {
                Preconditions.checkArgument((uRI.segmentCount() > 0 ? 1 : 0) != 0, (String)"URI must have locale: %s", (Object[])new Object[]{uRI});
                return LocalizedVariant.of(new Locale.Builder().setLanguageTag(uRI.segment(0)).build());
            }
            return null;
        });
        a = new WeakInterningHashSet<LocalizedVariant>(){
            private static final long serialVersionUID = 1L;

            protected int hashCode(LocalizedVariant localizedVariant) {
                return Objects.hashCode(localizedVariant.getLocale());
            }

            protected boolean equals(LocalizedVariant localizedVariant, LocalizedVariant localizedVariant2) {
                return Objects.equals(localizedVariant.getLocale(), localizedVariant2.getLocale());
            }
        };
    }
}

