/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.astah.emf.edit.provider.IChangeProcessor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.domain.EditingDomain;

public class ComposedChangeProcessor
implements Iterable<IChangeProcessor>,
IChangeProcessor {
    protected List<IChangeProcessor> changeProcessors = new ArrayList<IChangeProcessor>();

    @Override
    public Command processChange(EditingDomain editingDomain, Collection<?> collection, List<Notification> list) {
        CompoundCommand compoundCommand = null;
        for (IChangeProcessor iChangeProcessor : this.changeProcessors) {
            Command command = iChangeProcessor.processChange(editingDomain, collection, list);
            if (command == null) continue;
            if (compoundCommand == null) {
                compoundCommand = new CompoundCommand();
            }
            compoundCommand.append(command);
        }
        return compoundCommand != null ? compoundCommand.unwrap() : null;
    }

    public boolean isEmpty() {
        return this.changeProcessors.isEmpty();
    }

    public List<IChangeProcessor> getChangeProcessors() {
        return Collections.unmodifiableList(this.changeProcessors);
    }

    public IChangeProcessor unwrap() {
        return this.changeProcessors.size() != 1 ? this : this.changeProcessors.get(0);
    }

    @Override
    public Iterator<IChangeProcessor> iterator() {
        return this.changeProcessors.iterator();
    }

    public void addChangeProcessor(IChangeProcessor iChangeProcessor) {
        Objects.requireNonNull(iChangeProcessor, "changeProcessor");
        this.changeProcessors.add(iChangeProcessor);
    }

    public void removeChangeProcessor(IChangeProcessor iChangeProcessor) {
        this.changeProcessors.remove(iChangeProcessor);
    }
}

