/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.provider;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.astah.emf.common.ecore.DataTypes;
import net.astah.emf.edit.command.DataTypeInitializeCopyCommand;
import net.astah.emf.edit.command.DiagramCommandParameter;
import net.astah.emf.edit.command.DiagramCommands;
import net.astah.emf.edit.command.DiagramCopyCommand;
import net.astah.emf.edit.command.InitializeFeatureCommand;
import net.astah.emf.edit.command.PasteCommand;
import net.astah.emf.edit.command.ResolveCloneCommand;
import net.astah.emf.edit.command.ResolveCopyCommand;
import net.astah.emf.edit.command.ResolveOrphanCommand;
import net.astah.emf.edit.command.ResolveReferenceCommand;
import net.astah.emf.edit.provider.AliasVariant;
import net.astah.emf.edit.provider.ExtensionPropertyDescriptor;
import net.astah.emf.edit.provider.ExtraLabelVariant;
import net.astah.emf.edit.provider.IItemVariantLabelProvider;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.Variant;
import net.astah.model.extension.ExtensionFactory;
import net.astah.model.extension.ExtensionPackage;
import net.astah.model.extension.ExtraInfo;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.provider.EModelElementItemProvider;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstahItemProviderAdapter
extends ItemProviderAdapter
implements InitializeFeatureCommand.Helper {
    private static final Logger b = LoggerFactory.getLogger(AstahItemProviderAdapter.class);
    private static final EModelElementItemProvider c = new EModelElementItemProvider(null);

    public AstahItemProviderAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addDefinitionPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addDefinitionPropertyDescriptor(Object object) {
        ExtraInfo extraInfo;
        Adapter adapter;
        AdapterFactory adapterFactory = ItemProviders.getAdapterFactory(object);
        if (adapterFactory != null && (adapter = adapterFactory.adapt((Notifier)(extraInfo = ExtensionFactory.eINSTANCE.createExtraInfo()), IItemPropertySource.class)) instanceof IItemPropertySource) {
            extraInfo.eAdapters().clear();
            IItemPropertySource iItemPropertySource = (IItemPropertySource)adapter;
            IItemPropertyDescriptor iItemPropertyDescriptor = iItemPropertySource.getPropertyDescriptor(object, (Object)"definition");
            this.itemPropertyDescriptors.add(new ExtensionPropertyDescriptor(adapterFactory, null, ExtensionPackage.Literals.EXTRA_INFO, iItemPropertyDescriptor));
        }
    }

    protected Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            if (object instanceof EModelElement) {
                this.childrenFeatures.addAll(c.getChildrenFeatures(object));
            }
        }
        return this.childrenFeatures;
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() instanceof EModelElement) {
            switch (notification.getFeatureID(EModelElement.class)) {
                case 0: {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                    return;
                }
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> collection, Object object) {
        super.collectNewChildDescriptors(collection, object);
        if (object instanceof EModelElement) {
            collection.add(this.createChildParameter(EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS, EcoreFactory.eINSTANCE.createEAnnotation()));
        }
    }

    public String getText(Object object, Object object2) {
        if (object2 == IItemVariantLabelProvider.QUALIFIED_VARIANT) {
            return this.getQualifiedText(object);
        }
        if (object2 == ExtraLabelVariant.NAME) {
            return this.getName(object);
        }
        return this.getText(object);
    }

    public String getQualifiedText(Object object) {
        return this.getText(object);
    }

    public String getName(Object object) {
        EStructuralFeature eStructuralFeature;
        if (object instanceof EObject && (eStructuralFeature = this.getLabelFeature()) != null) {
            Object object2 = this.getFeatureValue((EObject)object, eStructuralFeature);
            return Objects.toString(object2, null);
        }
        return this.getText(object);
    }

    public IItemPropertyDescriptor getPropertyDescriptor(Object object, Object object2) {
        IItemPropertyDescriptor iItemPropertyDescriptor;
        String string;
        Variant variant;
        URI uRI = Variant.variantURI(object2);
        if (uRI != null && (variant = Variant.resolve(uRI)) != null && (string = variant.unwrapPropertyID(uRI)) != null && (iItemPropertyDescriptor = this.getPropertyDescriptor(object, string)) != null) {
            return this.createVariantPropertyDescriptor(object, iItemPropertyDescriptor, variant);
        }
        return super.getPropertyDescriptor(object, object2);
    }

    public IItemPropertyDescriptor getTextPropertyDescriptor(Object object) {
        EStructuralFeature eStructuralFeature = this.getLabelFeature();
        if (eStructuralFeature != null) {
            return this.getPropertyDescriptor(object, eStructuralFeature);
        }
        return null;
    }

    public IItemPropertyDescriptor getTextPropertyDescriptor(Object object, Object object2) {
        IItemPropertyDescriptor iItemPropertyDescriptor;
        IItemPropertyDescriptor iItemPropertyDescriptor2;
        EStructuralFeature eStructuralFeature = this.getLabelFeature();
        if (eStructuralFeature != null && (iItemPropertyDescriptor2 = this.getPropertyDescriptor(object, eStructuralFeature)) != null && (iItemPropertyDescriptor = this.createVariantPropertyDescriptor(object, iItemPropertyDescriptor2, object2)) != null) {
            return iItemPropertyDescriptor;
        }
        return this.getTextPropertyDescriptor(object);
    }

    protected IItemPropertyDescriptor createVariantPropertyDescriptor(Object object, IItemPropertyDescriptor iItemPropertyDescriptor, Object object2) {
        if (object2 instanceof AliasVariant) {
            return this.createAliasPropertyDescriptor(object, iItemPropertyDescriptor, (AliasVariant)object2);
        }
        return null;
    }

    protected IItemPropertyDescriptor createAliasPropertyDescriptor(Object object, IItemPropertyDescriptor iItemPropertyDescriptor, AliasVariant aliasVariant) {
        return null;
    }

    public boolean match(Object object2, Pattern pattern) {
        EStructuralFeature eStructuralFeature = this.getMatchFeature();
        if (object2 instanceof EObject && eStructuralFeature != null) {
            EObject eObject = (EObject)object2;
            if (!eStructuralFeature.isMany()) {
                Object object3 = eObject.eGet(eStructuralFeature);
                return pattern.matcher(Objects.toString(object3, "")).find();
            }
            Collection collection = (Collection)eObject.eGet(eStructuralFeature);
            return collection.stream().anyMatch(object -> pattern.matcher(Objects.toString(object, "")).find());
        }
        return false;
    }

    public void matchReplace(Object object, Pattern pattern, String string) {
        EStructuralFeature eStructuralFeature = this.getMatchFeature();
        if (object instanceof EObject && eStructuralFeature != null) {
            EObject eObject = (EObject)object;
            if (!eStructuralFeature.isMany()) {
                Object object2 = eObject.eGet(eStructuralFeature);
                String string2 = pattern.matcher(Objects.toString(object2, "")).replaceAll(string);
                eObject.eSet(eStructuralFeature, (Object)string2);
            } else {
                Collection collection = (Collection)eObject.eGet(eStructuralFeature);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object e : collection) {
                    arrayList.add(pattern.matcher(Objects.toString(e, "")).replaceAll(string));
                }
                eObject.eSet(eStructuralFeature, arrayList);
            }
        }
    }

    protected EStructuralFeature getMatchFeature() {
        EStructuralFeature eStructuralFeature = this.getLabelFeature();
        if (eStructuralFeature != null && eStructuralFeature.getEType().getInstanceClass() == String.class) {
            return eStructuralFeature;
        }
        return null;
    }

    protected EStructuralFeature getLabelFeature() {
        return null;
    }

    public boolean isDependentOn(EditingDomain editingDomain, Object object, Map<EStructuralFeature, Object> map, Collection<?> collection) {
        EObject eObject = (EObject)object;
        if (this.isDependingContainer(editingDomain, eObject, collection)) {
            return true;
        }
        for (Map.Entry<EStructuralFeature, Object> entry : map.entrySet()) {
            EStructuralFeature eStructuralFeature = entry.getKey();
            Object object2 = entry.getValue();
            assert (object2 != null) : "values must not be null";
            if (!this.isDependingFeature(editingDomain, eObject, eStructuralFeature, object2, collection)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDependingContainer(EditingDomain editingDomain, EObject eObject, Collection<?> collection) {
        return collection.contains(eObject.eContainer());
    }

    protected boolean isDependingFeature(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Object object, Collection<?> collection) {
        int n = eStructuralFeature.getLowerBound();
        return this.isDependingFeature(eObject, eStructuralFeature, object, n);
    }

    protected boolean isDependingFeature(EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n) {
        if (n > 0) {
            if (eStructuralFeature.isMany()) {
                Collection collection = (Collection)object;
                Collection collection2 = (Collection)eObject.eGet(eStructuralFeature);
                return n > collection2.size() - collection.size();
            }
            return true;
        }
        return false;
    }

    public void collectDependents(EditingDomain editingDomain, Object object, Collection<Object> collection) {
    }

    public void collectSharedComposites(EditingDomain editingDomain, Object object, Collection<Object> collection) {
    }

    public Collection<?> getIntentionDomains(Object object) {
        return Collections.emptySet();
    }

    public Command createDiagramCommand(Object object, EditingDomain editingDomain, Class<? extends Command> clazz, CommandParameter commandParameter) {
        Command command = null;
        CommandParameter commandParameter2 = commandParameter;
        commandParameter = this.unwrapCommandValues(commandParameter, clazz);
        if (clazz == CopyCommand.class) {
            command = this.createCopyCommand(object, editingDomain, commandParameter);
        } else if (clazz == PasteCommand.class) {
            command = this.createPasteCommand(object, editingDomain, commandParameter);
        } else if (clazz == ResolveCopyCommand.class) {
            command = this.createResolveCopyCommand(object, editingDomain, commandParameter);
        } else if (clazz == ResolveCloneCommand.class) {
            command = this.createResolveCloneCommand(object, editingDomain, commandParameter);
        } else if (clazz == ResolveReferenceCommand.class) {
            command = this.createResolveReferenceCommand(object, editingDomain, commandParameter);
        } else if (clazz == ResolveOrphanCommand.class) {
            command = this.createResolveOrphanCommand(object, editingDomain, commandParameter);
        }
        if (command == null) {
            return this.createCommand(object, editingDomain, clazz, commandParameter);
        }
        return this.wrapCommand(command, object, clazz, commandParameter, commandParameter2);
    }

    public Comparator<Object> getComparator(EditingDomain editingDomain, Object object) {
        return (object2, object3) -> this.compare(editingDomain, object, object2, object3);
    }

    protected int compare(EditingDomain editingDomain, Object object, Object object2, Object object3) {
        if (object2 != object3 && object instanceof EObject) {
            EObject eObject = (EObject)object;
            EStructuralFeature eStructuralFeature = this.getComparingFeature(object, object2);
            EStructuralFeature eStructuralFeature2 = this.getComparingFeature(object, object3);
            if (eStructuralFeature != null || eStructuralFeature2 != null) {
                int n = this.compareFeature(editingDomain, eObject, eStructuralFeature, eStructuralFeature2);
                if (n == 0 && eStructuralFeature == eStructuralFeature2) {
                    n = this.compareFeatureValue(editingDomain, eObject, eStructuralFeature, object2, object3);
                }
                return n;
            }
        }
        return 0;
    }

    protected int compareFeatureValue(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Object object, Object object2) {
        if (eStructuralFeature.isMany()) {
            List list = (List)eObject.eGet(eStructuralFeature);
            int n = list.indexOf(object);
            int n2 = list.indexOf(object2);
            if (n >= 0 && n2 >= 0) {
                return n - n2;
            }
        }
        return 0;
    }

    protected int compareFeature(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, EStructuralFeature eStructuralFeature2) {
        if (eStructuralFeature == eStructuralFeature2) {
            return 0;
        }
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        for (EStructuralFeature eStructuralFeature3 : this.getComparingFeatures(eObject)) {
            if (eStructuralFeature3 == eStructuralFeature && n2 < 0) {
                n2 = n;
                if (n3 >= 0) break;
            }
            if (eStructuralFeature3 == eStructuralFeature2 && n3 < 0) {
                n3 = n;
                if (n2 >= 0) break;
            }
            ++n;
        }
        if (n2 >= 0 && n3 >= 0) {
            return n2 - n3;
        }
        return 0;
    }

    protected EStructuralFeature getComparingFeature(Object object, Object object2) {
        EReference eReference;
        EObject eObject;
        if (object2 instanceof EObject && (eObject = (EObject)object2).eContainer() == object && (eReference = eObject.eContainmentFeature()) != null) {
            return eReference;
        }
        return super.getChildFeature(object, object2);
    }

    protected Collection<? extends EStructuralFeature> getComparingFeatures(EObject eObject) {
        return eObject.eClass().getEAllReferences();
    }

    public void copyExtensions(EditingDomain editingDomain, Object object, Object object2) {
    }

    public boolean adjustSelection(EditingDomain editingDomain, Class<? extends Command> clazz, Object object, Set<Object> set) {
        if (clazz == CopyCommand.class) {
            return this.adjustCopySelection(editingDomain, object, set);
        }
        return false;
    }

    public Object getMoveVector(EditingDomain editingDomain, Object object, Object object2, Collection<?> collection) {
        return null;
    }

    public Collection<?> getResolvingFeatures(EditingDomain editingDomain, Object object, Object object3) {
        if (object3 instanceof EObject) {
            EObject eObject = (EObject)object3;
            Collection<? extends EStructuralFeature> collection = this.getResolvableFeatures(editingDomain, object, eObject);
            return Collections2.filter(collection, object2 -> object2 instanceof EReference && this.shouldResolve(editingDomain, object, eObject, (EReference)object2));
        }
        return Collections.emptySet();
    }

    protected Collection<? extends EStructuralFeature> getResolvableFeatures(EditingDomain editingDomain, Object object, EObject eObject) {
        return eObject.eClass().getEAllReferences();
    }

    protected boolean shouldResolve(EditingDomain editingDomain, Object object, EObject eObject, EReference eReference) {
        return !eReference.isContainment() && eReference.isChangeable() && !eReference.isDerived() && eReference.getEOpposite() == null;
    }

    public Object resolveEquivalent(EditingDomain editingDomain, Object object, Object object2, Object object3) {
        if (object2 instanceof EObject && object3 instanceof EObject) {
            return this.resolveEquivalent(editingDomain, object, (EObject)object2, (EObject)object3);
        }
        return null;
    }

    protected Object getContext(CommandParameter commandParameter) {
        if (commandParameter instanceof DiagramCommandParameter) {
            return ((DiagramCommandParameter)commandParameter).getContext();
        }
        return null;
    }

    public Command createCommand(Object object, EditingDomain editingDomain, Class<? extends Command> clazz, CommandParameter commandParameter) {
        if (clazz == InitializeFeatureCommand.class) {
            CommandParameter commandParameter2 = commandParameter;
            commandParameter = this.unwrapCommandValues(commandParameter, clazz);
            Command command = this.createInitializeFeatureCommand(editingDomain, commandParameter.getEOwner(), commandParameter.getEStructuralFeature());
            return this.wrapCommand(command, object, clazz, commandParameter, commandParameter2);
        }
        return super.createCommand(object, editingDomain, clazz, commandParameter);
    }

    protected Command createInitializeFeatureCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature) {
        return new InitializeFeatureCommand(editingDomain, eObject, eStructuralFeature, this);
    }

    @Override
    public Object generateInitialValue(Object object, Object object2) {
        return SetCommand.UNSET_VALUE;
    }

    protected Command createCopyCommand(Object object, EditingDomain editingDomain, CommandParameter commandParameter) {
        Object object2 = this.getContext(commandParameter);
        EObject eObject = commandParameter.getEOwner();
        CopyCommand.Helper helper = (CopyCommand.Helper)commandParameter.getValue();
        return this.createCopyCommand(editingDomain, object2, eObject, helper);
    }

    protected Command createCopyCommand(EditingDomain editingDomain, Object object, EObject eObject, CopyCommand.Helper helper) {
        return new DiagramCopyCommand(editingDomain, object, eObject, helper, editingDomain.getOptimizeCopy());
    }

    protected Command createPasteCommand(Object object, EditingDomain editingDomain, CommandParameter commandParameter) {
        Object object2 = this.getContext(commandParameter);
        EStructuralFeature eStructuralFeature = commandParameter.getEStructuralFeature();
        if (eStructuralFeature != null) {
            EObject eObject = commandParameter.getEOwner();
            Collection collection = commandParameter.getCollection();
            int n = commandParameter.getIndex();
            return this.createPasteCommand(editingDomain, object2, eObject, eStructuralFeature, collection, n);
        }
        return this.factorPasteCommand(editingDomain, object2, commandParameter);
    }

    protected Command createPasteCommand(EditingDomain editingDomain, Object object, EObject eObject, EStructuralFeature eStructuralFeature, Collection<?> collection, int n) {
        return new PasteCommand(editingDomain, object, eObject, eStructuralFeature, collection, n);
    }

    protected Command factorPasteCommand(EditingDomain editingDomain, Object object, CommandParameter commandParameter) {
        return PasteCommand.createAsAddCommand(editingDomain, commandParameter);
    }

    protected Command createInitializeCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        if (DataTypes.isDataType((EObject)eObject)) {
            return new DataTypeInitializeCopyCommand(editingDomain, eObject, helper);
        }
        return super.createInitializeCopyCommand(editingDomain, eObject, helper);
    }

    protected Iterable<EReference> getContainmentReferences(EObject eObject, Object object) {
        return Iterables.filter((Iterable)eObject.eClass().getEAllContainments(), eReference -> eReference.isMany() && eReference.isChangeable() && eReference.getEType().isInstance(object));
    }

    protected Command createResolveCopyCommand(Object object, EditingDomain editingDomain, CommandParameter commandParameter) {
        Object object2 = this.getContext(commandParameter);
        Collection collection = commandParameter.getCollection();
        return this.createResolveCopyCommand(editingDomain, object2, collection);
    }

    protected Command createResolveCopyCommand(EditingDomain editingDomain, Object object, Collection<?> collection) {
        return new ResolveCopyCommand(editingDomain, object, collection);
    }

    protected Command createResolveCloneCommand(Object object, EditingDomain editingDomain, CommandParameter commandParameter) {
        Object object2 = this.getContext(commandParameter);
        Collection collection = commandParameter.getCollection();
        return this.createResolveCloneCommand(editingDomain, object2, collection);
    }

    protected Command createResolveCloneCommand(EditingDomain editingDomain, Object object, Collection<?> collection) {
        return new ResolveCloneCommand(editingDomain, object, collection);
    }

    protected Command createResolveReferenceCommand(Object object, EditingDomain editingDomain, CommandParameter commandParameter) {
        Object object2 = this.getContext(commandParameter);
        EObject eObject = commandParameter.getEOwner();
        Object object3 = commandParameter.getValue();
        int n = commandParameter.getIndex();
        EStructuralFeature eStructuralFeature = commandParameter.getEStructuralFeature() != null ? commandParameter.getEStructuralFeature() : this.getSetFeature(eObject, object3);
        return this.createResolveReferenceCommand(editingDomain, object2, eObject, object3, eStructuralFeature, n);
    }

    protected Command createResolveReferenceCommand(EditingDomain editingDomain, Object object, EObject eObject, Object object2, EStructuralFeature eStructuralFeature, int n) {
        if (n == -1) {
            return this.createResolveReferenceCommand(editingDomain, object, eObject, eStructuralFeature, object2);
        }
        return new ResolveReferenceCommand(editingDomain, object, eObject, eStructuralFeature, object2, n);
    }

    protected Command createResolveReferenceCommand(EditingDomain editingDomain, Object object, EObject eObject, EStructuralFeature eStructuralFeature, Object object2) {
        return new ResolveReferenceCommand(editingDomain, object, eObject, eStructuralFeature, object2);
    }

    protected Command createResolveOrphanCommand(Object object, EditingDomain editingDomain, CommandParameter commandParameter) {
        Object object2 = this.getContext(commandParameter);
        EObject eObject = commandParameter.getEOwner();
        return this.createResolveOrphanCommand(editingDomain, object2, eObject);
    }

    protected Command createResolveOrphanCommand(EditingDomain editingDomain, Object object, EObject eObject) {
        return new ResolveOrphanCommand(editingDomain, object, eObject);
    }

    protected boolean adjustCopySelection(EditingDomain editingDomain, Object object, Set<Object> set) {
        return false;
    }

    protected EObject resolveEquivalent(EditingDomain editingDomain, Object object, EObject eObject, EObject eObject2) {
        return this.resolveProxy(editingDomain, eObject2);
    }

    protected EObject resolveProxy(EditingDomain editingDomain, EObject eObject) {
        if (!eObject.eIsProxy()) {
            return eObject;
        }
        if (eObject instanceof InternalEObject) {
            URI uRI = ((InternalEObject)eObject).eProxyURI();
            ResourceSet resourceSet = editingDomain.getResourceSet();
            if (this.resourceExists(resourceSet, uRI.trimFragment())) {
                try {
                    return resourceSet.getEObject(uRI, true);
                }
                catch (RuntimeException runtimeException) {
                    b.info("Failed to resolve proxy", (Throwable)runtimeException);
                }
            }
        }
        return null;
    }

    protected boolean resourceExists(ResourceSet resourceSet, URI uRI) {
        return resourceSet.getResource(uRI, false) != null || resourceSet.getURIConverter().exists(uRI, null);
    }

    public Object resize(EditingDomain editingDomain, Object object, Object object2, Object object3, boolean bl) {
        return object3;
    }

    protected static <E> boolean addIfNotNull(Collection<E> collection, E e) {
        return e != null && collection.add(e);
    }

    protected static <E> boolean addIfInstanceOf(Collection<? super E> collection, Object object, Class<E> clazz) {
        return clazz.isInstance(object) && collection.add(clazz.cast(object));
    }

    public Command createResolveCloneReferenceCommand(EditingDomain editingDomain, Object object, EList<EObject> eList, EObject eObject, EReference eReference, Object object2, int n) {
        if (!this.shouldResolveCloneReference(eList, eObject, eReference, object2)) {
            return IdentityCommand.INSTANCE;
        }
        return this.createResolveCloneReferenceCommand(editingDomain, object, eObject, eReference, object2, n);
    }

    protected boolean shouldResolveCloneReference(EList<EObject> eList, EObject eObject, EReference eReference, Object object) {
        if (object instanceof EObject) {
            EObject eObject2;
            EObject eObject3 = eObject2 = (EObject)object;
            while (eObject3 != null) {
                if (eList.contains((Object)eObject3)) {
                    return false;
                }
                eObject3 = this.getContainer(eObject3);
            }
        }
        return true;
    }

    protected EObject getContainer(EObject eObject) {
        return eObject != null ? eObject.eContainer() : null;
    }

    protected Command createResolveCloneReferenceCommand(EditingDomain editingDomain, Object object, EObject eObject, EReference eReference, Object object2, int n) {
        Object object3 = DiagramCommands.resolveEquivalent(editingDomain, object, object2);
        if (object3 == null) {
            return IdentityCommand.INSTANCE;
        }
        return SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)eReference, (Object)object3, (int)n);
    }

    public Set<Object> getNewSelection(EditingDomain editingDomain, Class<? extends Command> clazz, Object object, Collection<?> collection) {
        return Sets.newHashSet();
    }

    public URI getImageSource(EObject eObject) {
        return null;
    }

    public boolean isImageAspectRatioPreserved(EObject eObject) {
        return false;
    }

    public String getTypeText(Object object) {
        return super.getTypeText(object);
    }

    public String getModifyingText(Object object) {
        return null;
    }

    public Command parseModifyingText(EditingDomain editingDomain, Object object, String string) {
        return null;
    }

    public Object getStyledText(Object object) {
        return null;
    }
}

