/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.notify;

import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.common.notify.EFeaturePathObserver;
import net.astah.emf.edit.EMFEditExtensionPlugin;
import net.astah.emf.edit.notify.ViewerNotificationQueue;
import net.astah.emf.edit.notify.ViewerPathNotification;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFeaturePathPropagator
implements EFeaturePathObserver.Listener,
IDisposable,
INotifyChangedListener {
    private static final Logger a = LoggerFactory.getLogger(EFeaturePathPropagator.class);
    protected final Queue<IViewerNotification> queue = new ViewerNotificationQueue();
    protected final EFeaturePathObserver observer;
    protected IChangeNotifier changeNotifier;

    public EFeaturePathPropagator(IChangeNotifier iChangeNotifier) {
        this(iChangeNotifier, EFeaturePathObserver.create());
    }

    public EFeaturePathPropagator(IChangeNotifier iChangeNotifier, EFeaturePathObserver eFeaturePathObserver) {
        this.observer = Objects.requireNonNull(eFeaturePathObserver, "observer");
        this.setChangeNotifier(iChangeNotifier);
    }

    public Queue<IViewerNotification> getQueue() {
        return this.queue;
    }

    public EFeaturePathObserver getObserver() {
        return this.observer;
    }

    public IChangeNotifier getChangeNotifier() {
        return this.changeNotifier;
    }

    public void setChangeNotifier(IChangeNotifier iChangeNotifier) {
        if (this.changeNotifier != null) {
            this.changeNotifier.removeListener((INotifyChangedListener)this);
            this.changeNotifier = null;
        }
        if (iChangeNotifier != null) {
            iChangeNotifier.addListener((INotifyChangedListener)this);
        }
        this.changeNotifier = iChangeNotifier;
    }

    public IDisposable observe(EFeaturePath eFeaturePath) {
        return this.getObserver().observe(eFeaturePath, (EFeaturePathObserver.Listener)this);
    }

    public void notifyChanged(Notification notification) {
        if (this.shouldHandle(notification)) {
            this.handleNotification(notification);
        }
    }

    public void handleNotification(Notification notification) {
        if (notification instanceof IViewerNotification) {
            IViewerNotification iViewerNotification = (IViewerNotification)notification;
            if (notification.getNotifier() != null && this.queue.offer(iViewerNotification)) {
                this.observer.handleClass((Notification)iViewerNotification);
            }
        } else {
            this.observer.notifyChanged(notification);
        }
    }

    public void handleContainment(Notification notification, Collection<EObject> collection) {
        this.observer.handleContainment(notification, collection);
    }

    public void pathChanged(EFeaturePathObserver.Event event) {
        EFeaturePath eFeaturePath = event.getPath();
        Notification notification = event.getNotification();
        for (EObject eObject : event.getAffectedObjects()) {
            this.propagateNotification(eFeaturePath, (Notifier)eObject, notification);
        }
    }

    public void dispose() {
        this.setChangeNotifier(null);
    }

    protected boolean shouldHandle(Notification notification) {
        return !notification.isTouch();
    }

    protected void propagateNotification(EFeaturePath eFeaturePath, Notifier notifier, Notification notification) {
        if (this.changeNotifier != null) {
            a.trace("Propagate {} to {}", (Object)notification, (Object)notifier);
            ViewerPathNotification viewerPathNotification = new ViewerPathNotification(eFeaturePath, notifier, notification);
            this.changeNotifier.fireNotifyChanged((Notification)viewerPathNotification);
        } else {
            a.warn("Discards propagation of {} to {}", (Object)notification, (Object)notifier);
        }
    }

    public static interface Registry {
        public static final Registry INSTANCE = EMFEditExtensionPlugin.getFeaturePathPropagationRegistry();

        public Collection<EFeaturePath> getPaths(EClass var1);

        public static interface Descriptor {
            public EFeaturePath getPath(EClass var1);
        }
    }
}

