/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.job;

import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.astah.jomt.jutil.SwingInvoker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jobs {
    private static final Logger a = LoggerFactory.getLogger(Jobs.class);

    public static void uiSafeJoin(Job job) throws InterruptedException {
        if (SwingInvoker.isOnEDT()) {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            SecondaryLoop secondaryLoop = eventQueue.createSecondaryLoop();
            job.addJobChangeListener(Jobs.done(iJobChangeEvent -> secondaryLoop.exit(), false));
            if (job.getState() != 0) {
                secondaryLoop.enter();
                job.join();
            }
        } else {
            job.join();
        }
    }

    public static void blockEDT(int n) {
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new b(n));
    }

    public static void visit(IStatus iStatus, Consumer<IStatus> consumer) {
        if (iStatus.isMultiStatus()) {
            for (IStatus iStatus2 : iStatus.getChildren()) {
                Jobs.visit(iStatus2, consumer);
            }
        } else {
            consumer.accept(iStatus);
        }
    }

    public static void log(Logger logger, IStatus iStatus) {
        switch (iStatus.getSeverity()) {
            case 4: 
            case 8: {
                logger.error(iStatus.getMessage(), iStatus.getException());
                break;
            }
            case 2: {
                logger.warn(iStatus.getMessage(), iStatus.getException());
                break;
            }
            case 1: {
                logger.info(iStatus.getMessage(), iStatus.getException());
                break;
            }
            case 0: {
                logger.debug(iStatus.getMessage(), iStatus.getException());
            }
        }
    }

    public static IJobChangeListener done(Consumer<IJobChangeEvent> consumer, boolean bl) {
        return new net.astah.emf.edit.job.a(bl, consumer);
    }

    public static CompletableFuture<IJobChangeEvent> toCompletableFuture(Job job) {
        return Jobs.toCompletableFuture(job, false);
    }

    public static CompletableFuture<IJobChangeEvent> toCompletableFuture(Job job, boolean bl) {
        CompletableFuture<IJobChangeEvent> completableFuture = new CompletableFuture<IJobChangeEvent>();
        job.addJobChangeListener((IJobChangeListener)new a(completableFuture, bl, null));
        return completableFuture;
    }

    static class a
    extends JobChangeAdapter {
        private final CompletableFuture<IJobChangeEvent> a;
        private final boolean b;

        private a(CompletableFuture<IJobChangeEvent> completableFuture, boolean bl) {
            this.a = completableFuture;
            this.b = bl;
        }

        public void done(IJobChangeEvent iJobChangeEvent) {
            if (this.b) {
                SwingInvoker.runLaterInEDT(() -> this.a(iJobChangeEvent));
            } else {
                this.a(iJobChangeEvent);
            }
        }

        void a(IJobChangeEvent iJobChangeEvent) {
            IStatus iStatus = iJobChangeEvent.getResult();
            if (iStatus != null) {
                switch (iStatus.getSeverity()) {
                    case 8: {
                        this.a.cancel(false);
                        break;
                    }
                    case 4: {
                        this.a.completeExceptionally(new CoreException(iStatus));
                        break;
                    }
                    default: {
                        this.a.complete(iJobChangeEvent);
                    }
                }
            }
        }

        /* synthetic */ a(CompletableFuture completableFuture, boolean bl, net.astah.emf.edit.job.a a2) {
            this(completableFuture, bl);
        }
    }

    static class b
    extends JobChangeAdapter {
        private final Map<Job, CountDownLatch> a = new ConcurrentHashMap<Job, CountDownLatch>();
        private final int b;

        public b(int n) {
            this.b = n;
        }

        public void running(IJobChangeEvent iJobChangeEvent) {
            CountDownLatch countDownLatch;
            Job job = iJobChangeEvent.getJob();
            if (job.getPriority() <= this.b && this.a.putIfAbsent(job, countDownLatch = new CountDownLatch(1)) == null) {
                CountDownLatch countDownLatch2 = new CountDownLatch(1);
                SwingInvoker.runInEDT(() -> {
                    try {
                        a.debug("Suspending EDT: {}", (Object)job);
                        countDownLatch2.countDown();
                        countDownLatch.await();
                        a.debug("Resumed EDT: {}", (Object)job);
                    }
                    catch (InterruptedException interruptedException) {
                        a.debug("Interrupted");
                        Thread.currentThread().interrupt();
                    }
                });
                try {
                    countDownLatch2.await(10L, TimeUnit.SECONDS);
                    a.trace("Running: {}", (Object)job);
                }
                catch (InterruptedException interruptedException) {
                    a.debug("Interrupted");
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void done(IJobChangeEvent iJobChangeEvent) {
            Job job = iJobChangeEvent.getJob();
            CountDownLatch countDownLatch = this.a.remove(job);
            if (countDownLatch != null) {
                a.trace("Done: {}", (Object)job);
                countDownLatch.countDown();
            }
        }
    }
}

