/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.job;

import net.astah.emf.common.transaction.Transactions;
import net.astah.emf.edit.Messages;
import net.astah.emf.edit.job.TransactionalJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandJob
extends TransactionalJob {
    private static final Logger a = LoggerFactory.getLogger(CommandJob.class);
    protected Command command;

    public CommandJob(TransactionalEditingDomain transactionalEditingDomain, Command command) {
        this(transactionalEditingDomain, command.getLabel(), command);
    }

    public CommandJob(TransactionalEditingDomain transactionalEditingDomain, String string, Command command) {
        super(transactionalEditingDomain, string);
        this.setPriority(10);
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        CommandStack commandStack = this.domain.getCommandStack();
        if (commandStack instanceof TransactionalCommandStack) {
            try {
                ((TransactionalCommandStack)commandStack).execute(this.command, null);
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
            catch (RollbackException rollbackException) {
                if (!Transactions.isConstraintViolation((RollbackException)rollbackException)) {
                    a.error("A transaction has rolled back", (Throwable)rollbackException);
                }
                IStatus[] iStatusArray = new IStatus[]{rollbackException.getStatus()};
                return new MultiStatus("<N/A>", 0, iStatusArray, Messages.CommandJob_rolledback, (Throwable)rollbackException);
            }
        } else {
            commandStack.execute(this.command);
        }
        return Status.OK_STATUS;
    }
}

