/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.domain;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.astah.emf.common.util.GarbageCollector;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.domain.a;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GarbageCollectorTrigger
extends ResourceSetListenerImpl {
    private static final Logger a = LoggerFactory.getLogger(GarbageCollectorTrigger.class);
    private static final NotificationFilter b = new a();

    public GarbageCollectorTrigger() {
        super(b);
    }

    public GarbageCollectorTrigger(NotificationFilter notificationFilter) {
        super(notificationFilter != null ? notificationFilter : b);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent resourceSetChangeEvent) throws RollbackException {
        Set<GarbageCollector> set = this.getGarbageCollectors(resourceSetChangeEvent.getNotifications());
        if (set.isEmpty()) {
            return null;
        }
        HashSet hashSet = new HashSet();
        for (GarbageCollector garbageCollector : set) {
            Set set2 = garbageCollector.collectGarbage();
            if (set2.isEmpty()) continue;
            a.debug("Destroy collected garbage: {}", (Object)set2);
            hashSet.addAll(set2);
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        return DestroyCommand.create((EditingDomain)resourceSetChangeEvent.getEditingDomain(), hashSet);
    }

    protected Set<GarbageCollector> getGarbageCollectors(List<Notification> list) {
        HashSet<GarbageCollector> hashSet = new HashSet<GarbageCollector>();
        for (Notification notification : list) {
            GarbageCollector garbageCollector;
            Notifier notifier = this.getCollectorTarget(notification);
            if (notifier == null || (garbageCollector = this.getGarbageCollector(notifier)) == null) continue;
            hashSet.add(garbageCollector);
        }
        return hashSet;
    }

    protected GarbageCollector getGarbageCollector(Notifier notifier) {
        return GarbageCollector.getInstance((Notifier)notifier);
    }

    protected Notifier getCollectorTarget(Notification notification) {
        Object object = notification.getNotifier();
        if (object instanceof Notifier) {
            return (Notifier)object;
        }
        return null;
    }
}

