/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.command;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import net.astah.emf.common.datatransfer.EMFResourceTransferable;
import net.astah.emf.common.datatransfer.TransferableResourceImpl;
import net.astah.emf.common.resource.ResourceSets;
import net.astah.emf.edit.ClippedFragment;
import net.astah.emf.edit.command.DiagramCommands;
import net.astah.emf.edit.command.XMLCopyToClipboardCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class XMLPasteFromClipboardCommand
extends PasteFromClipboardCommand {
    private static final Logger a = LoggerFactory.getLogger(XMLPasteFromClipboardCommand.class);
    private static Marker b = MarkerFactory.getMarker((String)"clipboard");
    protected Resource resource;
    protected Collection<Object> original;
    protected Collection<Object> resolved;

    public XMLPasteFromClipboardCommand(EditingDomain editingDomain, Object object, Object object2, int n, boolean bl) {
        super(editingDomain, object, object2, n, bl);
    }

    public XMLPasteFromClipboardCommand(EditingDomain editingDomain, Object object, Object object2, int n) {
        this(editingDomain, object, object2, n, true);
    }

    protected boolean prepare() {
        this.resolved = this.resolveClipboard();
        if (this.resolved == null) {
            return super.prepare();
        }
        this.original = this.domain.getClipboard();
        this.domain.setClipboard(this.resolved);
        try {
            boolean bl = super.prepare();
            return bl;
        }
        finally {
            this.domain.setClipboard(this.original);
        }
    }

    public void doExecute() {
        a.trace(b, "doExecute()");
        if (this.resolved != null) {
            this.domain.setClipboard(this.resolved);
        }
        super.doExecute();
        this.disposeResource();
    }

    public void doUndo() {
        super.doUndo();
        if (this.resolved != null) {
            this.domain.setClipboard(this.original);
        }
    }

    public void doRedo() {
        if (this.resolved != null) {
            this.domain.setClipboard(this.resolved);
        }
        super.doRedo();
    }

    public void doDispose() {
        this.resolved = null;
        this.original = null;
        this.disposeResource();
        super.doDispose();
    }

    protected Collection<Object> resolveClipboard() {
        ClippedFragment clippedFragment = this.resolveClippedFragment();
        if (clippedFragment != null) {
            return this.getFragmentContents(clippedFragment);
        }
        return null;
    }

    protected ClippedFragment resolveClippedFragment() {
        if (this.resource == null) {
            this.resource = this.getTransferredResource();
            if (this.resource == null) {
                return null;
            }
        }
        return DiagramCommands.getClippedFragment(this.resource);
    }

    protected Collection<Object> getFragmentContents(ClippedFragment clippedFragment) {
        return clippedFragment.getContents();
    }

    protected void disposeResource() {
        if (this.resource != null) {
            ResourceSet resourceSet = this.resource.getResourceSet();
            if (resourceSet != null) {
                ResourceSets.dispose((ResourceSet)resourceSet);
            } else {
                this.resource.unload();
            }
            this.resource = null;
        }
    }

    protected Resource getTransferredResource() {
        if (XMLCopyToClipboardCommand.systemClipboard != null) {
            a.debug(b, "Retrieving XMI resource from system clipboard");
            Transferable transferable = XMLCopyToClipboardCommand.systemClipboard.getContents((Object)this);
            if (transferable != null) {
                try {
                    Object object = this.getTransferData(transferable);
                    if (object instanceof Resource) {
                        return (Resource)object;
                    }
                }
                catch (IOException iOException) {
                    a.info(b, "Failed to retrieve clipboard data", (Throwable)iOException);
                    return null;
                }
                a.debug(b, "System clipboard doesn't contain XMI resource");
            } else {
                a.debug(b, "System clipboard is empty");
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getTransferData(Transferable transferable) throws IOException {
        try {
            if (!transferable.isDataFlavorSupported(EMFResourceTransferable.XMI_INPUT_STREAM_FLAVOR)) return null;
            Object object = transferable.getTransferData(EMFResourceTransferable.XMI_INPUT_STREAM_FLAVOR);
            if (!(object instanceof InputStream)) return null;
            try (InputStream inputStream = (InputStream)object;){
                Resource resource = this.createTransferableResource();
                resource.load(inputStream, null);
                Resource resource2 = resource;
                return resource2;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            throw new AssertionError(unsupportedFlavorException.getMessage(), unsupportedFlavorException);
        }
    }

    protected Resource createTransferableResource() {
        return TransferableResourceImpl.create();
    }
}

