/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.command;

import java.awt.AWTError;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collection;
import net.astah.emf.common.datatransfer.EMFResourceTransferable;
import net.astah.emf.edit.command.CopyAsResourceCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.CopyToClipboardCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class XMLCopyToClipboardCommand
extends CopyToClipboardCommand {
    private static final Logger a = LoggerFactory.getLogger(XMLCopyToClipboardCommand.class);
    private static Marker b = MarkerFactory.getMarker((String)"clipboard");
    protected static final Clipboard systemClipboard = XMLCopyToClipboardCommand.a();

    public XMLCopyToClipboardCommand(EditingDomain editingDomain, Collection<?> collection) {
        super(editingDomain, collection);
    }

    public void doExecute() {
        a.trace(b, "doExecute()");
        super.doExecute();
        this.processResult();
    }

    protected boolean prepare() {
        Collection<?> collection = this.adjustSourceObjects(this.sourceObjects);
        this.copyCommand = this.createCopyCommand(this.domain, collection);
        return this.copyCommand.canExecute();
    }

    protected Collection<?> adjustSourceObjects(Collection<?> collection) {
        return collection;
    }

    protected void processResult() {
        Resource resource = CopyAsResourceCommand.getResultResource(this.copyCommand);
        if (resource != null) {
            try {
                this.copyToSystemClipboard((Collection<EObject>)resource.getContents());
            }
            finally {
                resource.unload();
            }
        }
    }

    protected void copyToSystemClipboard(Collection<EObject> collection) {
        if (systemClipboard != null && collection != null && !collection.isEmpty()) {
            try {
                a.debug(b, "Copying XMI into system clipboard");
                EMFResourceTransferable eMFResourceTransferable = new EMFResourceTransferable(collection);
                systemClipboard.setContents((Transferable)eMFResourceTransferable, (ClipboardOwner)eMFResourceTransferable);
            }
            catch (IOException | IllegalStateException exception) {
                a.warn(b, "Failed to update clipboard Contents", (Throwable)exception);
            }
        }
    }

    protected Command createCopyCommand(EditingDomain editingDomain, Collection<?> collection) {
        CopyCommand.Helper helper = this.createHelper();
        return this.createCopyFragmentCommand(editingDomain, collection, helper);
    }

    protected CopyCommand.Helper createHelper() {
        return new CopyCommand.Helper();
    }

    protected Command createCopyFragmentCommand(EditingDomain editingDomain, Collection<?> collection, CopyCommand.Helper helper) {
        return new CopyAsResourceCommand(editingDomain, collection, helper);
    }

    private static Clipboard a() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (HeadlessException headlessException) {
            a.debug(b, "Failed to retrieve system clipboard", (Throwable)headlessException);
            return null;
        }
        catch (AWTError aWTError) {
            a.warn(b, "Failed to retrieve system clipboard", (Throwable)aWTError);
            return null;
        }
    }
}

