/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SynchronizeListCommand
extends AbstractOverrideableCommand {
    protected EObject owner;
    protected EStructuralFeature feature;
    protected EList<Object> ownerList;
    protected Iterable<?> collection;
    protected List<Change> changes;

    public SynchronizeListCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Iterable<?> iterable) {
        super(editingDomain, "SynchronizeListCommand", "Synchronize list with the particular collection");
        this.owner = eObject;
        this.feature = eStructuralFeature;
        this.collection = iterable;
        this.ownerList = SynchronizeListCommand.getOwnerList((EObject)eObject, (EStructuralFeature)eStructuralFeature);
    }

    public SynchronizeListCommand(EditingDomain editingDomain, EList<?> eList, Iterable<?> iterable) {
        super(editingDomain, "SynchronizeListCommand", "Synchronize list with the particular collection");
        this.collection = iterable;
        EList<?> eList2 = eList;
        this.ownerList = eList2;
    }

    public EditingDomain getDomain() {
        return this.domain;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public EList<?> getOwnerList() {
        return this.ownerList;
    }

    public Iterable<?> getCollection() {
        return this.collection;
    }

    public List<Change> getChanges() {
        return this.changes;
    }

    public Collection<?> doGetAffectedObjects() {
        return Collections.singleton(this.owner);
    }

    public Collection<?> doGetResult() {
        return this.getChanges();
    }

    public void doExecute() {
        int n = this.changes.size();
        block5: for (int i = 0; i < n; ++i) {
            Change change = this.changes.get(i);
            switch (change.a) {
                case ADD_LITERAL: {
                    this.ownerList.add(change.d, change.b);
                    continue block5;
                }
                case MOVE_LITERAL: {
                    this.ownerList.move(change.d, change.c);
                    continue block5;
                }
                case REMOVE_LITERAL: {
                    this.ownerList.remove(change.c);
                }
            }
        }
    }

    public void doUndo() {
        int n;
        int n2 = n = this.changes.size();
        while (n2-- > 0) {
            Change change = this.changes.get(n2);
            switch (change.a) {
                case ADD_LITERAL: {
                    this.ownerList.remove(change.d);
                    break;
                }
                case MOVE_LITERAL: {
                    this.ownerList.move(change.c, change.d);
                    break;
                }
                case REMOVE_LITERAL: {
                    this.ownerList.add(change.c, change.b);
                }
            }
        }
    }

    public void doRedo() {
        this.doExecute();
    }

    protected boolean prepare() {
        if (this.owner != null && this.domain.isReadOnly(this.owner.eResource())) {
            return false;
        }
        if (this.ownerList == null || this.collection == null) {
            return false;
        }
        this.changes = this.getDifferences();
        return !this.getDifferences().isEmpty();
    }

    protected List<Change> getDifferences() {
        Change change = this.a();
        BasicEList.FastCompare fastCompare = new BasicEList.FastCompare(this.ownerList);
        ArrayList<Change> arrayList = new ArrayList<Change>();
        int n = 0;
        int n2 = 0;
        Change change2 = change;
        block5: while (change2.e != null) {
            Change change3 = change2;
            change2 = change2.e;
            change3.e = null;
            switch (change2.a) {
                case ADD_LITERAL: {
                    change2.d = n;
                    fastCompare.add(change2.d, change2.b);
                    arrayList.add(change2);
                    break;
                }
                case MOVE_LITERAL: {
                    change2.c = fastCompare.indexOf(change2.b);
                    assert (n <= change2.c);
                    if (n == change2.c) break;
                    change2.d = n;
                    fastCompare.move(change2.d, change2.c);
                    arrayList.add(change2);
                    break;
                }
                case REMOVE_LITERAL: {
                    change2.c -= n2++;
                    fastCompare.remove(change2.c);
                    arrayList.add(change2);
                    continue block5;
                }
            }
            ++n;
        }
        return arrayList;
    }

    protected boolean equals(Object object, Object object2) {
        return this.useEquals() ? Objects.equals(object, object2) : object == object2;
    }

    protected boolean useEquals() {
        return true;
    }

    Change a() {
        Object object3;
        int n = 0;
        Change change = new Change(null, null, -1);
        Object object2 = change;
        for (Object object3 : this.ownerList) {
            Change change2 = new Change(ChangeKind.REMOVE_LITERAL, object3, n++);
            ((Change)object2).e = change2;
            object2 = change2;
        }
        Change change3 = new Change(null, null, -1);
        object3 = change3;
        block1: for (Object e : this.collection) {
            Change change4 = change;
            while (change4.e != null) {
                Change change5 = change4;
                change4 = change4.e;
                if (!this.equals(e, change4.b)) continue;
                change4.a = ChangeKind.MOVE_LITERAL;
                change5.e = change4.e;
                if (object2 == change4) {
                    object2 = change5;
                }
                change4.e = null;
                ((Change)object3).e = change4;
                object3 = change4;
                continue block1;
            }
            ((Change)object3).e = change4 = new Change(ChangeKind.ADD_LITERAL, e, -1);
            object3 = change4;
        }
        if (change.e != null) {
            ((Change)object2).e = change3.e;
            return change;
        }
        return change3;
    }

    public static class Change {
        ChangeKind a;
        Object b;
        int c;
        int d;
        Change e;

        Change(ChangeKind changeKind, Object object, int n) {
            this.a = changeKind;
            this.b = object;
            this.c = n;
            this.d = -1;
        }

        public ChangeKind getType() {
            return this.a;
        }

        public Object getValue() {
            return this.b;
        }

        public int getOldPosition() {
            return this.c;
        }

        public int getNewPosition() {
            return this.d;
        }
    }
}

