/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import net.astah.emf.common.ecore.EcoreCopier;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SynchronizeCommand
extends CompoundCommand {
    protected EditingDomain domain;
    protected EObject owner;
    protected Collection<EStructuralFeature> features;
    protected EObject value;

    public static Command create(EditingDomain editingDomain, EObject eObject, EObject eObject2) {
        return new SynchronizeCommand(editingDomain, eObject, null, eObject2);
    }

    public static Command create(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, EObject eObject2) {
        return new SynchronizeCommand(editingDomain, eObject, Collections.singletonList(eStructuralFeature), eObject2);
    }

    public static Command create(EditingDomain editingDomain, EObject eObject, Collection<EStructuralFeature> collection, EObject eObject2) {
        return new SynchronizeCommand(editingDomain, eObject, collection, eObject2);
    }

    public SynchronizeCommand(EditingDomain editingDomain, EObject eObject, Collection<EStructuralFeature> collection, EObject eObject2) {
        super("SynchronizeCommand", "Synchronize object features");
        this.domain = editingDomain;
        this.owner = eObject;
        this.features = collection;
        this.value = eObject2;
    }

    public EditingDomain getDomain() {
        return this.domain;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public Collection<EStructuralFeature> getFeatures() {
        return this.features;
    }

    public EObject getValue() {
        return this.value;
    }

    protected boolean prepare() {
        if (this.domain == null || this.owner == null) {
            return false;
        }
        for (EStructuralFeature eStructuralFeature : this.getSynchronizingFeatures()) {
            if (!this.isSynchronizable(eStructuralFeature)) continue;
            this.synchronizeFeature(eStructuralFeature);
        }
        return super.prepare();
    }

    protected Collection<EStructuralFeature> getSynchronizingFeatures() {
        if (this.features != null && !this.features.isEmpty()) {
            return this.features;
        }
        return this.owner.eClass().getEAllStructuralFeatures();
    }

    protected boolean isSynchronizable(EStructuralFeature eStructuralFeature) {
        if (!eStructuralFeature.isChangeable()) {
            return false;
        }
        EStructuralFeature.Internal internal = (EStructuralFeature.Internal)eStructuralFeature;
        return internal.getEOpposite() == null || internal.isContainment();
    }

    protected void synchronizeFeature(EStructuralFeature eStructuralFeature) {
        if (!eStructuralFeature.getEContainingClass().isInstance((Object)this.value) || !this.isSet(this.value, eStructuralFeature)) {
            if (this.isSet(this.owner, eStructuralFeature)) {
                this.append(SetCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)eStructuralFeature, (Object)SetCommand.UNSET_VALUE));
            }
        } else {
            Object object;
            Object object2 = this.owner.eGet(eStructuralFeature);
            if (!this.equals(eStructuralFeature, object2, object = this.value.eGet(eStructuralFeature))) {
                Object object3 = this.convertValue(eStructuralFeature, object);
                this.append(SetCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)eStructuralFeature, (Object)object3));
            }
        }
    }

    protected Object convertValue(EStructuralFeature eStructuralFeature, Object collection) {
        if (((EStructuralFeature.Internal)eStructuralFeature).isContainment()) {
            EcoreCopier ecoreCopier = new EcoreCopier();
            collection = eStructuralFeature.isMany() ? ecoreCopier.copyAll(collection) : ecoreCopier.copy((EObject)collection);
        }
        return collection;
    }

    protected boolean isSet(EObject eObject, EStructuralFeature eStructuralFeature) {
        return eObject.eIsSet(eStructuralFeature);
    }

    protected boolean equals(EStructuralFeature eStructuralFeature, Object object, Object object2) {
        if (eStructuralFeature instanceof EReference && (((EReference)eStructuralFeature).isContainment() || !eStructuralFeature.isMany())) {
            return object == object2;
        }
        return Objects.equals(object, object2);
    }
}

