/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EMapRemoveCommand
extends CommandWrapper {
    protected EditingDomain domain;
    protected EObject owner;
    protected EReference feature;
    protected Collection<?> keys;

    public static Command create(EditingDomain editingDomain, EObject eObject, EReference eReference, Object object) {
        return new EMapRemoveCommand(editingDomain, eObject, eReference, Collections.singleton(object));
    }

    public static Command create(EditingDomain editingDomain, EObject eObject, EReference eReference, Collection<?> collection) {
        return new EMapRemoveCommand(editingDomain, eObject, eReference, collection);
    }

    public EMapRemoveCommand(EditingDomain editingDomain, EObject eObject, EReference eReference, Collection<?> collection) {
        super("EMapRemoveCommand", "Remove entry from EMap");
        this.domain = editingDomain;
        this.owner = eObject;
        this.feature = eReference;
        this.keys = collection;
    }

    protected Command createCommand() {
        if (this.domain == null || this.owner == null || this.feature == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Object object = this.owner.eGet((EStructuralFeature)this.feature);
        if (!(object instanceof EMap)) {
            return UnexecutableCommand.INSTANCE;
        }
        EMap eMap = (EMap)object;
        BasicEList.FastCompare fastCompare = new BasicEList.FastCompare();
        if (this.keys != null) {
            for (Object obj : this.keys) {
                int n = eMap.indexOfKey(obj);
                if (n < 0) continue;
                fastCompare.add(eMap.get(n));
            }
        }
        return RemoveCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)this.feature, (Collection)fastCompare);
    }
}

