/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.command;

import java.util.Objects;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EMapPutCommand
extends CommandWrapper {
    protected EditingDomain domain;
    protected EObject owner;
    protected EReference feature;
    protected EStructuralFeature keyFeature;
    protected EStructuralFeature valueFeature;
    protected Object key;
    protected Object value;

    public static Command create(EditingDomain editingDomain, EObject eObject, EReference eReference, Object object, Object object2) {
        return EMapPutCommand.create(editingDomain, eObject, eReference, null, null, object, object2);
    }

    public static Command create(EditingDomain editingDomain, EObject eObject, EReference eReference, EStructuralFeature eStructuralFeature, EStructuralFeature eStructuralFeature2, Object object, Object object2) {
        return new EMapPutCommand(editingDomain, eObject, eReference, eStructuralFeature, eStructuralFeature2, object, object2);
    }

    public EMapPutCommand(EditingDomain editingDomain, EObject eObject, EReference eReference, EStructuralFeature eStructuralFeature, EStructuralFeature eStructuralFeature2, Object object, Object object2) {
        super("EMapPutCommand", "Put entry to EMap");
        this.domain = editingDomain;
        this.owner = eObject;
        this.feature = eReference;
        this.keyFeature = eStructuralFeature;
        this.valueFeature = eStructuralFeature2;
        this.key = object;
        this.value = object2;
    }

    public EditingDomain getDomain() {
        return this.domain;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public EReference getFeature() {
        return this.feature;
    }

    public EStructuralFeature getKeyFeature() {
        return this.keyFeature;
    }

    public EStructuralFeature getValueFeature() {
        return this.valueFeature;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    protected Command createCommand() {
        if (this.domain == null || this.owner == null || this.feature == null) {
            return UnexecutableCommand.INSTANCE;
        }
        EClass eClass = this.feature.getEReferenceType();
        if (eClass.isAbstract()) {
            throw new IllegalArgumentException("feature.getEReferenceType() must be a concrete class");
        }
        Object object = this.owner.eGet((EStructuralFeature)this.feature);
        if (!(object instanceof EMap)) {
            return UnexecutableCommand.INSTANCE;
        }
        EMap eMap = (EMap)object;
        int n = eMap.indexOfKey(this.key);
        if (n < 0) {
            EObject eObject = EcoreUtil.create((EClass)eClass);
            eObject.eSet(this.resolveKeyFeature(eClass), this.key);
            eObject.eSet(this.resolveValueFeature(eClass), this.value);
            return AddCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)this.feature, (Object)eObject);
        }
        EObject eObject = (EObject)eMap.get(n);
        return SetCommand.create((EditingDomain)this.domain, (Object)eObject, (Object)this.resolveValueFeature(eClass), (Object)this.value);
    }

    protected EStructuralFeature resolveKeyFeature(EClass eClass) {
        if (this.keyFeature != null) {
            return this.keyFeature;
        }
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("key");
        return Objects.requireNonNull(eStructuralFeature, "Missing keyFeature");
    }

    protected EStructuralFeature resolveValueFeature(EClass eClass) {
        if (this.valueFeature != null) {
            return this.valueFeature;
        }
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("value");
        return Objects.requireNonNull(eStructuralFeature, "Missing valueFeature");
    }
}

