/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.command;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.astah.emf.common.ecore.DataTypes;
import net.astah.emf.common.ecore.EComparators;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.command.Commands;
import net.astah.emf.edit.provider.AstahItemProviderAdapter;
import net.astah.emf.edit.provider.IItemDependencyProvider;
import net.astah.emf.edit.provider.ItemProviders;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class DestroyCommand
extends CompoundCommand {
    private static final Logger a = LoggerFactory.getLogger(DestroyCommand.class);
    private static final Marker b = MarkerFactory.getMarker((String)"command");
    protected EditingDomain domain;
    protected Collection<?> collection;

    public static Command create(EditingDomain editingDomain, Object object) {
        return DestroyCommand.create(editingDomain, Collections.singleton(object));
    }

    public static Command create(EditingDomain editingDomain, Collection<?> collection) {
        return editingDomain.createCommand(DestroyCommand.class, new CommandParameter(null, null, collection));
    }

    public DestroyCommand(EditingDomain editingDomain, CommandParameter commandParameter) {
        this(editingDomain, commandParameter.getCollection());
    }

    public DestroyCommand(EditingDomain editingDomain, Collection<?> collection) {
        super(Integer.MIN_VALUE);
        this.domain = editingDomain;
        this.collection = collection;
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    public static boolean isIntended(Command command) {
        return Iterables.all(Commands.getAllCommands(command, DestroyCommand.class), destroyCommand -> destroyCommand.isIntended());
    }

    public boolean isIntended() {
        Object object;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Collection<Object> collection = this.isPrepared ? ((object = (Command)Iterables.getLast((Iterable)this.commandList, null)) instanceof DeleteCommand ? ((DeleteCommand)object).getCollection() : Collections.emptySet()) : this.collectDependents(this.collection);
        object = new HashSet();
        for (Object object2 : this.collection) {
            if (object2 instanceof Reference) {
                object.addAll(((Reference)object2).getCollection());
                continue;
            }
            object.add(object2);
        }
        for (Object object2 : collection) {
            IItemDependencyProvider iItemDependencyProvider = ItemProviders.adapt(this.domain, object2, IItemDependencyProvider.class);
            if (iItemDependencyProvider == null) continue;
            Collection<?> collection2 = iItemDependencyProvider.getIntentionDomains(object2);
            if (object.contains(object2)) {
                hashSet.addAll(collection2);
            }
            hashSet2.addAll(collection2);
        }
        return hashSet.containsAll(hashSet2);
    }

    protected boolean prepare() {
        if (this.collection == null || this.collection.isEmpty()) {
            return false;
        }
        Collection<EObject> collection = this.collectDependents(this.collection);
        for (Reference reference : Iterables.filter(this.collection, Reference.class)) {
            this.appendSurvivorUnsetCommand(collection, reference);
        }
        if (!this.appendRelocateCommand(collection)) {
            return false;
        }
        List list = EcoreUtil.filterDescendants(collection);
        if (!list.isEmpty()) {
            this.append(DeleteCommand.create((EditingDomain)this.domain, (Collection)list));
        }
        return super.prepare();
    }

    protected Collection<EObject> collectDependents(Collection<?> collection) {
        boolean bl;
        Object object4;
        AdapterFactory adapterFactory = ItemProviders.getAdapterFactory(this.domain);
        if (adapterFactory == null) {
            return this.b();
        }
        Map<EObject, Map<EStructuralFeature, Object>> map = this.a();
        Set<Adapter> set = this.b();
        Set<EObject> set2 = this.expandObjects(collection);
        a<Object> a2 = new a<Object>(this.b());
        Set<EObject> set3 = this.b();
        a<Object> a3 = new a<Object>(this.b());
        for (Reference reference : Iterables.filter(collection, Reference.class)) {
            EObject object22 = reference.getOwner();
            set3.add(object22);
            a3.addAll(reference.getCollection());
            if (!this.a(object22) || !this.isDependentOn(object4 = adapterFactory.adapt((Notifier)object22, IItemDependencyProvider.class), object22, reference.a(), a2)) continue;
            a2.add(object22);
        }
        int n = 0;
        do {
            Object object2;
            if (++n > 10000) {
                a.warn(b, "Collecting dependent models is not converged: {}", collection);
                break;
            }
            a2.addAll(set2);
            for (EObject eObject : set2) {
                object4 = adapterFactory.adapt((Notifier)eObject, IItemDependencyProvider.class);
                if (!(object4 instanceof IItemDependencyProvider)) continue;
                object2 = (IItemDependencyProvider)object4;
                object2.collectDependents(this.domain, eObject, a2);
                object2.collectSharedComposites(this.domain, eObject, a3);
            }
            a3.removeAll(a2);
            for (EObject eObject : Iterables.filter(a3, EObject.class)) {
                if (this.hasSurvivingSharedOwner(adapterFactory, eObject, a2, set3)) continue;
                a2.add(eObject);
            }
            for (Object object3 : a2) {
                if (!(object3 instanceof EObject) || !set.add((Adapter)(object4 = (EObject)object3))) continue;
                this.collectInverseReferences(map, (EObject)object4);
            }
            for (Map.Entry entry : map.entrySet()) {
                object4 = (EObject)entry.getKey();
                if (a2.contains(object4)) continue;
                object2 = (Map)entry.getValue();
                Adapter adapter = adapterFactory.adapt((Notifier)object4, IItemDependencyProvider.class);
                if (!this.isDependentOn(adapter, (EObject)object4, (Map<EStructuralFeature, Object>)object2, a2)) continue;
                a2.add(object4);
            }
            bl = false;
            for (Object object4 : a2) {
                bl |= set2.add((EObject)object4);
            }
        } while (bl);
        return set2;
    }

    protected boolean hasSurvivingSharedOwner(AdapterFactory adapterFactory, EObject eObject, Collection<?> collection, Set<?> set) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (EStructuralFeature.Setting setting : this.getInverseReferences(eObject)) {
            Adapter adapter;
            EObject eObject2 = setting.getEObject();
            if (collection.contains(eObject2) || set.contains(eObject2) || !((adapter = adapterFactory.adapt((Notifier)eObject2, IItemDependencyProvider.class)) instanceof IItemDependencyProvider)) continue;
            IItemDependencyProvider iItemDependencyProvider = (IItemDependencyProvider)adapter;
            iItemDependencyProvider.collectSharedComposites(this.domain, eObject2, hashSet);
            if (!hashSet.contains(eObject)) continue;
            return true;
        }
        return false;
    }

    protected void collectInverseReferences(Map<EObject, Map<EStructuralFeature, Object>> map, EObject eObject) {
        for (EStructuralFeature.Setting setting : this.getInverseReferences(eObject)) {
            EObject eObject2;
            Object object;
            Object object2;
            EObject eObject3 = setting.getEObject();
            Map<EStructuralFeature, Object> map2 = map.get(eObject3);
            if (map2 == null && !this.a(eObject3)) continue;
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            Object object3 = object2 = map2 != null ? map2.get(eStructuralFeature) : null;
            if (eStructuralFeature.isMany()) {
                object = (EList)object2;
                if (object == null) {
                    object = new UniqueEList.FastCompare();
                }
                object.add((Object)eObject);
                eObject2 = object;
            } else {
                eObject2 = eObject;
            }
            if (map2 == null || map2.isEmpty()) {
                map.put(eObject3, Collections.singletonMap(eStructuralFeature, eObject2));
                continue;
            }
            if (object2 == eObject2) continue;
            if (map2.size() < 2) {
                object = this.a();
                map.put(eObject3, (Map<EStructuralFeature, Object>)object);
                object.putAll(map2);
                map2 = object;
            }
            map2.put(eStructuralFeature, eObject2);
        }
        for (EStructuralFeature.Setting setting : eObject.eContents()) {
            map.putIfAbsent((EObject)setting, Collections.emptyMap());
        }
    }

    protected boolean appendRelocateCommand(Collection<EObject> collection) {
        Object object;
        Object object2;
        a<Object> a2 = new a<Object>(this.b());
        TreeIterator treeIterator = EcoreUtil.getAllContents(collection);
        while (treeIterator.hasNext()) {
            object2 = (EObject)treeIterator.next();
            if (collection.contains(object2)) continue;
            a2.add(object2);
        }
        if (a2.isEmpty()) {
            return true;
        }
        object2 = this.a();
        for (EObject object3 : EcoreUtil.filterDescendants(a2)) {
            object = object3.eContainer();
            for (int eObject = 0; collection.contains(object) && eObject < 100000; ++eObject) {
                object = object.eContainer();
            }
            if (object == null) continue;
            Set<EObject> set = (Set<EObject>)object2.get(object);
            if (set == null) {
                set = this.b();
                object2.put(object, set);
            }
            set.add(object3);
        }
        if (object2.isEmpty()) {
            return true;
        }
        block3: for (Map.Entry entry : object2.entrySet()) {
            object = new ArrayList((Collection)entry.getValue());
            object.sort(EComparators.eObjectPath());
            EObject eObject = (EObject)entry.getKey();
            for (int n = 0; eObject != null && n < 100000; eObject = eObject.eContainer(), ++n) {
                if (this.appendIfCanExecute(AddCommand.create((EditingDomain)this.domain, (Object)eObject, null, (Collection)object))) continue block3;
            }
            return false;
        }
        return true;
    }

    protected void appendSurvivorUnsetCommand(Collection<EObject> collection, Reference reference) {
        ArrayList arrayList = new ArrayList();
        for (Object object : reference.getCollection()) {
            if (collection.contains(object)) continue;
            arrayList.add(object);
        }
        if (!arrayList.isEmpty()) {
            Object object;
            EObject eObject = reference.getOwner();
            object = reference.getFeature();
            if (object.isMany()) {
                this.append(RemoveCommand.create((EditingDomain)this.domain, (Object)eObject, object, arrayList));
            } else {
                this.append(SetCommand.create((EditingDomain)this.domain, (Object)eObject, object, (Object)SetCommand.UNSET_VALUE));
            }
        }
    }

    protected Set<EObject> expandObjects(Collection<?> collection) {
        a<EObject> a2 = new a<EObject>(this.b());
        for (Object obj : collection) {
            Object object = AdapterFactoryEditingDomain.unwrap(obj);
            if (object instanceof EObject) {
                a2.add((EObject)object);
                continue;
            }
            if (!(object instanceof Resource)) continue;
            Resource resource = (Resource)object;
            a2.addAll((Collection<EObject>)resource.getContents());
        }
        return a2;
    }

    protected Iterable<EStructuralFeature.Setting> getInverseReferences(EObject eObject) {
        if (!DataTypes.isDataType((EObject)eObject)) {
            ECrossReferenceAdapter eCrossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eObject);
            if (eCrossReferenceAdapter != null) {
                return Iterables.filter((Iterable)eCrossReferenceAdapter.getInverseReferences(eObject), setting -> this.a(setting.getEObject()));
            }
            a.warn(b, "ECrossReferenceAdapter is not attached on {}", (Object)eObject);
        }
        return Collections.emptySet();
    }

    protected boolean isDependentOn(Object object, EObject eObject, Map<EStructuralFeature, Object> map, Set<Object> set) {
        if (object instanceof IItemDependencyProvider) {
            IItemDependencyProvider iItemDependencyProvider = (IItemDependencyProvider)object;
            return iItemDependencyProvider.isDependentOn(this.domain, eObject, map, Collections.unmodifiableSet(set));
        }
        a.debug(b, "Use default provider for {}", (Object)eObject);
        AstahItemProviderAdapter astahItemProviderAdapter = new AstahItemProviderAdapter(null);
        return astahItemProviderAdapter.isDependentOn(this.domain, eObject, map, set);
    }

    private boolean a(Object object) {
        return object instanceof EObject && EObjects.isAttachedTo((EditingDomain)this.domain, (EObject)((EObject)object));
    }

    private <K, V> Map<K, V> a() {
        return Maps.newIdentityHashMap();
    }

    private <E> Set<E> b() {
        return Sets.newIdentityHashSet();
    }

    private class a<E>
    extends AbstractSet<E> {
        final Set<E> a;

        a(Set<E> set) {
            this.a = Objects.requireNonNull(set, "underlying");
        }

        @Override
        public Iterator<E> iterator() {
            return this.a.iterator();
        }

        @Override
        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean add(E e) {
            return DestroyCommand.this.a(e) && this.a.add(e);
        }

        @Override
        public boolean remove(Object object) {
            return this.a.remove(object);
        }
    }

    public static class Reference {
        private final EObject a;
        private final EStructuralFeature b;
        private final Collection<?> c;

        public Reference(EObject eObject, EStructuralFeature eStructuralFeature, Object object) {
            this(eObject, eStructuralFeature, Collections.singleton(Objects.requireNonNull(object, "value")));
        }

        public Reference(EObject eObject, EStructuralFeature eStructuralFeature, Collection<?> collection) {
            this.a = Objects.requireNonNull(eObject, "owner");
            this.b = Objects.requireNonNull(eStructuralFeature, "feature");
            this.c = Objects.requireNonNull(collection, "collection");
        }

        public EObject getOwner() {
            return this.a;
        }

        public EStructuralFeature getFeature() {
            return this.b;
        }

        public Collection<?> getCollection() {
            return this.c;
        }

        Map<EStructuralFeature, Object> a() {
            if (this.b.isMany()) {
                return Collections.singletonMap(this.b, this.c);
            }
            return Collections.singletonMap(this.b, Iterables.getFirst(this.c, null));
        }
    }
}

