/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.command;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.astah.emf.common.ecore.DataTypes;
import net.astah.emf.common.ecore.EComparators;
import net.astah.emf.edit.ClippedFragment;
import net.astah.emf.edit.ClippedReference;
import net.astah.emf.edit.EditFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.NotifyingList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CopyAsResourceCommand
extends CompoundCommand {
    protected EditingDomain domain;
    protected Collection<?> collection;
    protected CopyCommand.Helper copyHelper;
    protected ClippedFragment fragment;

    public static Command create(EditingDomain editingDomain, Collection<?> collection) {
        return new CopyAsResourceCommand(editingDomain, collection, new CopyCommand.Helper());
    }

    public CopyAsResourceCommand(EditingDomain editingDomain, Collection<?> collection, CopyCommand.Helper helper) {
        super(Integer.MIN_VALUE);
        this.domain = editingDomain;
        this.collection = collection;
        this.copyHelper = helper;
    }

    public static ClippedFragment getResultFragment(Command command) {
        return CopyAsResourceCommand.a(command, ClippedFragment.class);
    }

    public static Resource getResultResource(Command command) {
        InternalEObject internalEObject = CopyAsResourceCommand.a(command, InternalEObject.class);
        return internalEObject != null ? internalEObject.eDirectResource() : null;
    }

    static <E extends EObject> E a(Command command, Class<E> clazz) {
        Object object;
        Collection collection = command.getResult();
        if (collection instanceof NotifyingList && clazz.isInstance(object = ((NotifyingList)collection).getNotifier())) {
            return (E)((EObject)clazz.cast(object));
        }
        return null;
    }

    public EditingDomain getDomain() {
        return this.domain;
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    public ClippedFragment getFragment() {
        return this.fragment;
    }

    public Collection<?> getResult() {
        if (this.fragment == null) {
            this.fragment = this.createFragment(this.copyHelper, this.collection);
        }
        return this.fragment.getContents();
    }

    protected boolean prepare() {
        if (this.collection == null || this.collection.isEmpty()) {
            return false;
        }
        for (Object obj : this.collection) {
            this.append(this.createCopyCommand(this.domain, obj, this.copyHelper));
        }
        return super.prepare();
    }

    public void execute() {
        super.execute();
        for (Map.Entry entry : this.copyHelper.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            EObject eObject2 = (EObject)entry.getValue();
            Command command = this.attachContainer(this.copyHelper, eObject, eObject2);
            this.appendAndExecute(command);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fragment instanceof InternalEObject) {
            Resource.Internal internal = ((InternalEObject)this.fragment).eDirectResource();
            if (internal != null) {
                internal.unload();
            }
            this.fragment = null;
        }
    }

    protected Command createCopyCommand(EditingDomain editingDomain, Object object, CopyCommand.Helper helper) {
        CommandParameter commandParameter = new CommandParameter(object, null, (Object)helper);
        return editingDomain.createCommand(CopyCommand.class, commandParameter);
    }

    protected Command attachContainer(CopyCommand.Helper helper, EObject eObject, EObject eObject2) {
        EObject eObject3;
        EReference eReference;
        EObject eObject4 = this.a(eObject2);
        if (eObject4 == null && (eReference = eObject.eContainmentFeature()) != null && eReference.isChangeable() && (eObject3 = helper.getCopy(this.a(eObject))) != null) {
            if (eReference.isMany()) {
                return AddCommand.create((EditingDomain)this.domain, (Object)eObject3, (Object)eReference, (Object)eObject2);
            }
            return SetCommand.create((EditingDomain)this.domain, (Object)eObject3, (Object)eReference, (Object)eObject2);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected ClippedFragment createFragment(CopyCommand.Helper helper, Collection<?> collection) {
        ClippedFragment clippedFragment = EditFactory.eINSTANCE.createClippedFragment();
        EList eList = new ResourceImpl(URI.createURI((String)"")).getContents();
        eList.add((Object)clippedFragment);
        for (Map.Entry<EObject, EObject> entry : this.collectEntries(helper)) {
            EObject eObject = entry.getKey();
            EObject eObject2 = entry.getValue();
            this.attachResource((EList<EObject>)eList, eObject, eObject2);
            this.attachReference(clippedFragment, eObject, eObject2);
        }
        this.attachContents(helper, clippedFragment, collection);
        return clippedFragment;
    }

    protected List<Map.Entry<EObject, EObject>> collectEntries(CopyCommand.Helper helper) {
        List<Map.Entry<EObject, EObject>> list = helper.entrySet().stream().filter(entry -> !DataTypes.isDataType((EObject)((EObject)entry.getKey()))).collect(Collectors.toList());
        list.sort((entry, entry2) -> EComparators.eObjectPath().compare(entry.getKey(), entry2.getKey()));
        return list;
    }

    protected void attachResource(EList<EObject> eList, EObject eObject, EObject eObject2) {
        if (this.a(eObject2) == null) {
            eList.add((Object)eObject2);
        }
    }

    protected void attachContents(CopyCommand.Helper helper, ClippedFragment clippedFragment, Collection<?> collection) {
        EList<EObject> eList = clippedFragment.getContents();
        for (Object obj : collection) {
            EObject eObject = (EObject)helper.get(obj);
            if (eObject == null) continue;
            eList.add((Object)eObject);
        }
    }

    protected ClippedReference attachReference(ClippedFragment clippedFragment, EObject eObject, EObject eObject2) {
        ClippedReference clippedReference = EditFactory.eINSTANCE.createClippedReference();
        Resource resource = eObject.eResource();
        if (resource != null && resource.getURI() != null) {
            clippedReference.setOriginal(eObject);
        }
        clippedReference.setCopy(eObject2);
        clippedFragment.getReferences().add((Object)clippedReference);
        return clippedReference;
    }

    private EObject a(EObject eObject) {
        return ((InternalEObject)eObject).eInternalContainer();
    }
}

