/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit.command;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import lombok.NonNull;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.AbstractTreeIterator;

public class Commands {
    public static boolean execute(Command command) {
        if (command != null && command.canExecute()) {
            command.execute();
            command.dispose();
            return true;
        }
        command.dispose();
        return false;
    }

    public static Command chain(@NonNull Command command, @NonNull Command command2) {
        if (command == null) {
            throw new NullPointerException("result");
        }
        if (command2 == null) {
            throw new NullPointerException("command");
        }
        if (command2 != IdentityCommand.INSTANCE) {
            return command.chain(command2);
        }
        return command;
    }

    public static Command chainIfNotNull(@NonNull Command command, Command command2) {
        if (command == null) {
            throw new NullPointerException("result");
        }
        return command2 != null ? Commands.chain(command, command2) : command;
    }

    public static Command chainIfCanExecute(@NonNull Command command, Command command2) {
        if (command == null) {
            throw new NullPointerException("result");
        }
        if (command2 != null) {
            if (command2.canExecute()) {
                return Commands.chain(command, command2);
            }
            command2.dispose();
        }
        return command;
    }

    public static Iterable<Command> getAllCommands(Command command) {
        return () -> new CommandTreeIterator(command, true);
    }

    public static <T extends Command> Iterable<T> getAllCommands(Command command, Class<T> clazz) {
        return () -> Iterators.filter((Iterator)((Object)new CommandTreeIterator(command, true)), (Class)clazz);
    }

    static class CommandTreeIterator
    extends AbstractTreeIterator<Command> {
        private static final long serialVersionUID = 1L;

        CommandTreeIterator(Object object, boolean bl) {
            super(object, bl);
        }

        protected Iterator<? extends Command> getChildren(Object object) {
            if (object instanceof CompoundCommand) {
                return ((CompoundCommand)object).getCommandList().iterator();
            }
            if (object instanceof CommandWrapper) {
                return Collections.singleton(((CommandWrapper)object).getCommand()).iterator();
            }
            return Collections.emptyIterator();
        }
    }
}

