/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import net.astah.emf.common.ecore.plugin.RegistryReader;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.EMFEditExtensionPlugin;
import net.astah.emf.edit.Messages;
import net.astah.emf.edit.notify.EFeaturePathPropagator;
import net.astah.emf.edit.notify.EFeaturePathReactor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FeaturePathObserverRegistryReader
extends RegistryReader {
    private static final Logger m = LoggerFactory.getLogger(FeaturePathObserverRegistryReader.class);
    public static final String a = "featurePathObservers";
    static final String b = "package";
    static final String c = "reactor";
    static final String d = "propagation";
    static final String e = "path";
    static final String f = "segment";
    static final String g = "uri";
    static final String h = "class";
    static final String i = "inclusive";
    static final String j = "eClass";
    static final String k = "feature";
    static final String l = "inverse";
    private final EPackage.Registry n;

    public FeaturePathObserverRegistryReader(IExtensionRegistry iExtensionRegistry) {
        this(iExtensionRegistry, EPackage.Registry.INSTANCE);
    }

    public FeaturePathObserverRegistryReader(IExtensionRegistry iExtensionRegistry, @NonNull EPackage.Registry registry) {
        super(iExtensionRegistry, EMFEditExtensionPlugin.getPlugin().getSymbolicName(), a);
        if (registry == null) {
            throw new NullPointerException("packageRegistry");
        }
        this.n = registry;
    }

    protected void parse(IConfigurationElement iConfigurationElement) {
        switch (iConfigurationElement.getName()) {
            case "package": {
                this.a(iConfigurationElement);
                break;
            }
            case "propagation": {
                this.a(iConfigurationElement, this.c(iConfigurationElement));
                break;
            }
            case "reactor": {
                this.b(iConfigurationElement, this.c(iConfigurationElement));
                break;
            }
            default: {
                this.logError(iConfigurationElement, Messages.FeaturePathObserverRegistryReader_unexpectedElement);
            }
        }
    }

    protected void a(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute(g);
        if (string == null) {
            this.logMissingAttribute(iConfigurationElement, g);
            return;
        }
        if (!this.n.containsKey((Object)string)) {
            String string2 = NLS.bind((String)Messages.FeaturePathObserverRegistryReader_objectNotExist, (Object)"EPackage", (Object)string);
            this.logError(iConfigurationElement, string2);
            return;
        }
        PackageDescriptor packageDescriptor = this.c(iConfigurationElement);
        packageDescriptor.add(string);
        block8: for (IConfigurationElement iConfigurationElement2 : iConfigurationElement.getChildren()) {
            switch (iConfigurationElement2.getName()) {
                case "propagation": {
                    this.a(iConfigurationElement2, packageDescriptor);
                    continue block8;
                }
                case "reactor": {
                    this.b(iConfigurationElement2, packageDescriptor);
                    continue block8;
                }
                default: {
                    this.logError(iConfigurationElement, Messages.FeaturePathObserverRegistryReader_unexpectedElement);
                }
            }
        }
    }

    protected List<PropagationDescriptor> a(IConfigurationElement iConfigurationElement, PackageDescriptor packageDescriptor) {
        ArrayList<PropagationDescriptor> arrayList = new ArrayList<PropagationDescriptor>();
        block6: for (IConfigurationElement iConfigurationElement2 : iConfigurationElement.getChildren()) {
            switch (iConfigurationElement2.getName()) {
                case "path": {
                    PathDescriptor pathDescriptor = this.c(iConfigurationElement2, packageDescriptor);
                    if (pathDescriptor == null) continue block6;
                    arrayList.add(new PropagationDescriptor(packageDescriptor, pathDescriptor));
                    continue block6;
                }
                default: {
                    this.logError(iConfigurationElement2, Messages.FeaturePathObserverRegistryReader_unexpectedElement);
                }
            }
        }
        if (arrayList.isEmpty()) {
            this.logError(iConfigurationElement, NLS.bind((String)Messages.FeaturePathObserverRegistryReader_empty, (Object)"<propagation>", (Object)"<path>"));
            return null;
        }
        if (EMFEditExtensionPlugin.a != null) {
            EMFEditExtensionPlugin.a.addAll(arrayList);
        }
        return arrayList;
    }

    protected ReactorDescriptor b(IConfigurationElement iConfigurationElement, PackageDescriptor packageDescriptor) {
        if (iConfigurationElement.getAttribute(h) == null) {
            this.logMissingAttribute(iConfigurationElement, h);
            return null;
        }
        ReactorDescriptor reactorDescriptor = new ReactorDescriptor(iConfigurationElement, packageDescriptor);
        block6: for (IConfigurationElement iConfigurationElement2 : iConfigurationElement.getChildren()) {
            switch (iConfigurationElement2.getName()) {
                case "path": {
                    PathDescriptor pathDescriptor = this.c(iConfigurationElement2, packageDescriptor);
                    if (pathDescriptor == null) continue block6;
                    reactorDescriptor.getPathDescriptors().add(pathDescriptor);
                    continue block6;
                }
                default: {
                    this.logError(iConfigurationElement2, Messages.FeaturePathObserverRegistryReader_unexpectedElement);
                }
            }
        }
        if (reactorDescriptor.getPathDescriptors().isEmpty()) {
            this.logError(iConfigurationElement, NLS.bind((String)Messages.FeaturePathObserverRegistryReader_empty, (Object)"<reactor>", (Object)"<path>"));
            return null;
        }
        if (EMFEditExtensionPlugin.b != null) {
            EMFEditExtensionPlugin.b.addDescriptor(reactorDescriptor);
        }
        return reactorDescriptor;
    }

    protected PathDescriptor c(IConfigurationElement iConfigurationElement, PackageDescriptor packageDescriptor) {
        String string;
        Object object2;
        String string2 = iConfigurationElement.getAttribute(i);
        boolean bl = Boolean.parseBoolean(string2);
        PathDescriptor pathDescriptor = new PathDescriptor(bl);
        block6: for (Object object2 : iConfigurationElement.getChildren()) {
            switch (object2.getName()) {
                case "segment": {
                    SegmentDescriptor segmentDescriptor = this.b((IConfigurationElement)object2);
                    if (segmentDescriptor == null) continue block6;
                    pathDescriptor.add(segmentDescriptor);
                    continue block6;
                }
                default: {
                    this.logError((IConfigurationElement)object2, Messages.FeaturePathObserverRegistryReader_unexpectedElement);
                }
            }
        }
        if (pathDescriptor.isEmpty()) {
            this.logError(iConfigurationElement, NLS.bind((String)Messages.FeaturePathObserverRegistryReader_empty, (Object)"<path>", (Object)"<segment>"));
            return null;
        }
        SegmentDescriptor segmentDescriptor = (SegmentDescriptor)pathDescriptor.get(0);
        URI uRI = pathDescriptor.getOrigin();
        if (uRI == null) {
            object2 = NLS.bind((String)Messages.FeaturePathObserverRegistryReader_noContextClass, (Object)segmentDescriptor.getFeature());
            this.logError(iConfigurationElement, (String)object2);
            return null;
        }
        if (uRI.isRelative()) {
            if (packageDescriptor.isEmpty()) {
                object2 = NLS.bind((String)Messages.FeaturePathObserverRegistryReader_unqualifiedRelativeClass, (Object)uRI);
                this.logError(iConfigurationElement, (String)object2);
                return null;
            }
            string = null;
        } else {
            string = uRI.trimFragment().toString();
        }
        if (string != null && !this.n.containsKey((Object)string)) {
            object2 = NLS.bind((String)Messages.FeaturePathObserverRegistryReader_objectNotExist, (Object)"EPackage", (Object)string);
            this.logError(iConfigurationElement, (String)object2);
            return null;
        }
        return pathDescriptor;
    }

    protected SegmentDescriptor b(IConfigurationElement iConfigurationElement) {
        String string;
        URI uRI;
        String string2 = iConfigurationElement.getAttribute(j);
        if (string2 != null) {
            uRI = this.a(iConfigurationElement, string2);
            if (uRI == null) {
                return null;
            }
        } else {
            uRI = null;
        }
        if ((string = iConfigurationElement.getAttribute(k)) == null) {
            this.logMissingAttribute(iConfigurationElement, k);
            return null;
        }
        URI uRI2 = this.a(iConfigurationElement, string);
        if (uRI2 == null) {
            return null;
        }
        String string3 = iConfigurationElement.getAttribute(l);
        boolean bl = Boolean.parseBoolean(string3);
        return new SegmentDescriptor(uRI, uRI2, bl);
    }

    private PackageDescriptor c(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getContributor().getName();
        return new PackageDescriptor(this.n, string);
    }

    private URI a(IConfigurationElement iConfigurationElement, String string) {
        try {
            return URI.createURI((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = NLS.bind((String)Messages.FeaturePathObserverRegistryReader_parseURIFailed, (Object)string);
            this.logError(iConfigurationElement, string2, illegalArgumentException);
            return null;
        }
    }

    public static class SegmentDescriptor {
        protected final URI eClass;
        protected final URI feature;
        protected final boolean inverse;

        public SegmentDescriptor(URI uRI, URI uRI2, boolean bl) {
            this.eClass = this.a(uRI, uRI2, bl);
            this.feature = uRI2;
            this.inverse = bl;
        }

        public URI getEClass() {
            return this.eClass;
        }

        public URI getFeature() {
            return this.feature;
        }

        public boolean isInverse() {
            return this.inverse;
        }

        URI a(URI uRI, URI uRI2, boolean bl) {
            int n;
            String string;
            if (uRI != null) {
                return uRI;
            }
            if (!bl && (string = uRI2.fragment()) != null && (n = string.lastIndexOf(47)) >= 0) {
                String string2 = string.substring(0, n);
                return uRI2.trimFragment().appendFragment(string2);
            }
            return null;
        }
    }

    public static class PathDescriptor
    extends ArrayList<SegmentDescriptor> {
        protected final boolean inclusive;

        public PathDescriptor(boolean bl) {
            this.inclusive = bl;
        }

        public boolean isInclusive() {
            return this.inclusive;
        }

        public URI getOrigin() {
            return ((SegmentDescriptor)this.get(0)).getEClass();
        }
    }

    public static class ReactorDescriptor
    extends RegistryReader.PluginClassDescriptor
    implements EFeaturePathReactor.Descriptor {
        protected final List<PathDescriptor> pathDescriptors = new ArrayList<PathDescriptor>();
        protected final PackageDescriptor packageDescriptor;
        protected EFeaturePathReactor reactor;
        protected List<EFeaturePath> paths;

        public ReactorDescriptor(IConfigurationElement iConfigurationElement, PackageDescriptor packageDescriptor) {
            super(iConfigurationElement, FeaturePathObserverRegistryReader.h);
            this.packageDescriptor = packageDescriptor;
        }

        public List<PathDescriptor> getPathDescriptors() {
            return this.pathDescriptors;
        }

        @Override
        public synchronized boolean isApplicable(EClass eClass) {
            if (this.paths == null) {
                return this.pathDescriptors.stream().anyMatch(pathDescriptor -> this.packageDescriptor.isApplicable(eClass, pathDescriptor.getOrigin()));
            }
            return this.paths.stream().anyMatch(eFeaturePath -> eFeaturePath.getEClass().isSuperTypeOf(eClass));
        }

        @Override
        public synchronized EFeaturePathReactor getReactor() {
            if (this.reactor == null) {
                this.reactor = (EFeaturePathReactor)this.createInstance();
            }
            return this.reactor;
        }

        @Override
        public synchronized List<EFeaturePath> getPaths() {
            if (this.paths == null) {
                ArrayList<EFeaturePath> arrayList = new ArrayList<EFeaturePath>();
                try {
                    for (PathDescriptor pathDescriptor : this.pathDescriptors) {
                        arrayList.add(this.packageDescriptor.createPath(pathDescriptor));
                    }
                }
                catch (CoreException coreException) {
                    throw new WrappedException((Exception)((Object)coreException));
                }
                this.paths = arrayList;
            }
            return this.paths;
        }
    }

    public static class PropagationDescriptor
    implements EFeaturePathPropagator.Registry.Descriptor {
        protected final PackageDescriptor packageDescriptor;
        protected final PathDescriptor pathDescriptor;

        public PropagationDescriptor(PackageDescriptor packageDescriptor, PathDescriptor pathDescriptor) {
            this.packageDescriptor = packageDescriptor;
            this.pathDescriptor = pathDescriptor;
        }

        @Override
        public EFeaturePath getPath(EClass eClass) {
            if (eClass == null || this.packageDescriptor.isApplicable(eClass, this.pathDescriptor.getOrigin())) {
                try {
                    return this.packageDescriptor.createPath(this.pathDescriptor);
                }
                catch (CoreException coreException) {
                    throw new WrappedException((Exception)((Object)coreException));
                }
            }
            return null;
        }
    }

    public static class PackageDescriptor
    extends ArrayList<String> {
        protected final String contributorName;
        protected final EPackage.Registry packageRegistry;

        public PackageDescriptor(EPackage.Registry registry, String string) {
            this.packageRegistry = registry;
            this.contributorName = string;
        }

        public boolean isApplicable(EClass eClass2, URI uRI) {
            String string;
            Collection<String> collection;
            if (uRI.isRelative()) {
                collection = this;
                string = this.a(uRI);
            } else {
                collection = Collections.singleton(uRI.trimFragment().toString());
                string = uRI.fragment();
            }
            return this.isAppropriate(eClass2, collection, string) || eClass2.getEAllSuperTypes().stream().anyMatch(eClass -> this.isAppropriate((EClass)eClass, collection, string));
        }

        protected boolean isAppropriate(EClass eClass, Collection<String> collection, String string) {
            EPackage ePackage = eClass.getEPackage();
            return collection.contains(ePackage.getNsURI()) && eClass == ePackage.eResource().getEObject(string);
        }

        public EFeaturePath createPath(PathDescriptor pathDescriptor) throws CoreException {
            EFeaturePath.Builder builder = EFeaturePath.builder();
            builder.inclusive(pathDescriptor.isInclusive());
            EClassifier eClassifier = null;
            for (SegmentDescriptor segmentDescriptor : pathDescriptor) {
                URI uRI = segmentDescriptor.getEClass();
                URI uRI2 = segmentDescriptor.getFeature();
                boolean bl = segmentDescriptor.isInverse();
                eClassifier = this.addSegment(builder, eClassifier, uRI, uRI2, bl);
            }
            EFeaturePath eFeaturePath = builder.create();
            m.trace("A feature path {} has created.", (Object)eFeaturePath);
            return eFeaturePath;
        }

        protected EClassifier addSegment(EFeaturePath.Builder builder, EClassifier eClassifier, URI uRI, URI uRI2, boolean bl) throws CoreException {
            if (eClassifier != null && !(eClassifier instanceof EClass)) {
                throw new CoreException(this.a(NLS.bind((String)Messages.FeaturePathObserverRegistryReader_extraSegment, (Object)uRI2)));
            }
            EClass eClass = uRI != null ? this.resolveClass(eClassifier, uRI) : (EClass)eClassifier;
            try {
                if (bl) {
                    EReference eReference = this.resolveFeature(EReference.class, eClass, uRI2);
                    builder.addInverse(eClass, eReference);
                    return eReference.getEContainingClass();
                }
                EStructuralFeature eStructuralFeature = this.resolveFeature(EStructuralFeature.class, eClass, uRI2);
                EClass eClass2 = eStructuralFeature.getEContainingClass();
                if (eClass.isSuperTypeOf(eClass2)) {
                    builder.add(eClass2, eStructuralFeature);
                } else {
                    builder.add(eClass, eStructuralFeature);
                }
                return eStructuralFeature.getEType();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CoreException(this.a(NLS.bind((String)Messages.FeaturePathObserverRegistryReader_addSegmentFailed, (Object)uRI2), illegalArgumentException));
            }
        }

        protected EClass resolveClass(EClassifier eClassifier, URI uRI) throws CoreException {
            if (uRI.isRelative()) {
                String string = this.a(uRI);
                return this.resolveRelative(EClass.class, uRI, eClassifier, string);
            }
            return this.resolveAbsolute(EClass.class, uRI);
        }

        protected <T extends EStructuralFeature> T resolveFeature(Class<T> clazz, EClass eClass, URI uRI) throws CoreException {
            if (uRI.hasFragment() && uRI.trimFragment().isEmpty()) {
                URI uRI2 = EcoreUtil.getURI((EObject)eClass).appendFragment(uRI.fragment());
                return (T)((EStructuralFeature)this.resolveAbsolute(clazz, uRI2));
            }
            if (!uRI.isRelative() || uRI.hasFragment()) {
                return (T)((EStructuralFeature)this.resolveAbsolute(clazz, uRI));
            }
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(uRI.toString());
            if (clazz.isInstance(eStructuralFeature)) {
                return (T)((EStructuralFeature)clazz.cast(eStructuralFeature));
            }
            throw new CoreException(this.a(NLS.bind((String)Messages.FeaturePathObserverRegistryReader_objectNotExistInContext, (Object)clazz.getSimpleName(), (Object)uRI)));
        }

        protected <T extends EModelElement> T resolveAbsolute(Class<T> clazz, URI uRI) throws CoreException {
            String string = uRI.trimFragment().toString();
            Resource resource = this.resolveEPackage(string).eResource();
            EObject eObject = resource.getEObject(uRI.fragment());
            if (eObject == null) {
                throw new CoreException(this.a(NLS.bind((String)Messages.FeaturePathObserverRegistryReader_objectNotExist, (Object)clazz.getSimpleName(), (Object)uRI)));
            }
            if (!clazz.isInstance(eObject)) {
                throw new CoreException(this.a(NLS.bind((String)Messages.FeaturePathObserverRegistryReader_incompatibleObject, (Object)clazz.getSimpleName(), (Object)eObject)));
            }
            return (T)((EModelElement)clazz.cast(eObject));
        }

        protected <T extends EModelElement> T resolveRelative(Class<T> clazz, URI uRI, EClassifier eClassifier, String string) throws CoreException {
            Object object;
            Object object22;
            if (eClassifier != null && clazz.isInstance(object22 = (object = eClassifier.eResource()).getEObject(string))) {
                return (T)((EModelElement)clazz.cast(object22));
            }
            for (Object object22 : this) {
                Resource resource = this.resolveEPackage((String)object22).eResource();
                EObject eObject = resource.getEObject(string);
                if (!clazz.isInstance(eObject)) continue;
                return (T)((EModelElement)clazz.cast(eObject));
            }
            throw new CoreException(this.a(NLS.bind((String)Messages.FeaturePathObserverRegistryReader_objectNotExistInContext, (Object)clazz.getSimpleName(), (Object)uRI)));
        }

        protected EPackage resolveEPackage(String string) throws CoreException {
            EPackage ePackage = this.packageRegistry.getEPackage(string);
            if (ePackage == null) {
                throw new CoreException(this.a(NLS.bind((String)Messages.FeaturePathObserverRegistryReader_objectNotExist, (Object)"EPackage", (Object)string)));
            }
            return ePackage;
        }

        private String a(URI uRI) {
            if (uRI.hasFragment()) {
                return uRI.fragment();
            }
            return "//" + uRI.toString();
        }

        private IStatus a(String string) {
            return new Status(4, this.contributorName, string);
        }

        private IStatus a(String string, Throwable throwable) {
            return new Status(4, this.contributorName, string, throwable);
        }
    }
}

