/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class GarbageCollector
extends EContentAdapter {
    private final Map<EClass, List<EReference>> a = this.a();
    protected final Set<EReference> references = Collections.newSetFromMap(this.a());
    protected final Set<EObject> targets = Collections.newSetFromMap(this.a());
    protected final Set<EObject> rootObjects = Collections.newSetFromMap(this.a());
    protected final Set<EObject> affectedObjects = Collections.newSetFromMap(this.a());

    public static GarbageCollector getInstance(Notifier notifier) {
        EList eList = notifier.eAdapters();
        Adapter adapter = EcoreUtil.getAdapter((List)eList, GarbageCollector.class);
        if (adapter instanceof GarbageCollector) {
            return (GarbageCollector)adapter;
        }
        return null;
    }

    public boolean isAdapterForType(Object object) {
        return object == GarbageCollector.class;
    }

    public Set<EObject> collectGarbage() {
        if (!this.affectedObjects.isEmpty()) {
            this.removeSurvivors(this.affectedObjects);
            this.affectedObjects.removeAll(this.rootObjects);
            if (!this.affectedObjects.isEmpty()) {
                HashSet<EObject> hashSet = new HashSet<EObject>(this.affectedObjects);
                this.affectedObjects.clear();
                return Collections.unmodifiableSet(hashSet);
            }
        }
        return Collections.emptySet();
    }

    public boolean addReference(EReference eReference) {
        if (this.references.add(eReference)) {
            this.a.clear();
            return true;
        }
        return false;
    }

    public boolean addReferences(EReference ... eReferenceArray) {
        return this.addReferences(Arrays.asList(eReferenceArray));
    }

    public boolean addReferences(Collection<EReference> collection) {
        if (this.references.addAll(collection)) {
            this.a.clear();
            return true;
        }
        return false;
    }

    public boolean removeReference(EReference eReference) {
        if (this.references.remove(eReference)) {
            this.a.clear();
            return true;
        }
        return false;
    }

    public boolean removeReferences(EReference ... eReferenceArray) {
        return this.removeReferences(Arrays.asList(eReferenceArray));
    }

    public boolean removeReferences(Collection<EReference> collection) {
        if (this.references.removeAll(collection)) {
            this.a.clear();
            return true;
        }
        return false;
    }

    public static boolean shouldHandle(Notification notification) {
        if (notification.isTouch()) {
            return false;
        }
        switch (notification.getEventType()) {
            case 1: 
            case 2: {
                if (!(notification.getFeature() instanceof EReference)) {
                    return false;
                }
                return notification.getOldValue() != null;
            }
            case 4: 
            case 6: {
                if (!(notification.getFeature() instanceof EReference)) {
                    return GarbageCollector.a(notification);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean isIncluded(EReference eReference) {
        return this.references.contains(eReference);
    }

    protected boolean isRootObject(EObject eObject) {
        return false;
    }

    protected void selfAdapt(Notification notification) {
        EReference eReference;
        super.selfAdapt(notification);
        Object object = notification.getFeature();
        if (object instanceof EReference && this.isIncluded(eReference = (EReference)object)) {
            this.handleCrossReference(eReference, notification);
        }
    }

    protected void handleCrossReference(EReference eReference, Notification notification) {
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                EObject eObject;
                EObject eObject2 = (EObject)notification.getOldValue();
                if (eObject2 != null) {
                    this.a(eObject2);
                }
                if ((eObject = (EObject)notification.getNewValue()) == null) break;
                this.affectedObjects.remove(eObject);
                break;
            }
            case 5: {
                Collection collection = (Collection)notification.getNewValue();
                this.affectedObjects.removeAll(collection);
                break;
            }
            case 6: {
                Collection collection = (Collection)notification.getOldValue();
                this.a(collection);
                break;
            }
        }
    }

    protected void setTarget(EObject eObject) {
        this.targets.add(eObject);
        if (this.isRootObject(eObject)) {
            this.rootObjects.add(eObject);
        }
        super.setTarget(eObject);
    }

    protected void unsetTarget(EObject eObject) {
        super.unsetTarget(eObject);
        this.rootObjects.remove(eObject);
        this.targets.remove(eObject);
        for (EReference eReference : this.a(eObject.eClass())) {
            Object object = this.a(eObject, (EStructuralFeature)eReference);
            if (object == null) continue;
            if (eReference.isMany()) {
                Collection collection = (Collection)object;
                this.a(collection);
                continue;
            }
            this.a((EObject)object);
        }
        this.affectedObjects.remove(eObject);
    }

    protected void basicSetTarget(Notifier notifier) {
    }

    protected void basicUnsetTarget(Notifier notifier) {
    }

    protected void removeSurvivors(Set<EObject> set) {
        for (EObject eObject : this.targets) {
            for (EReference eReference : this.a(eObject.eClass())) {
                Object object = this.a(eObject, (EStructuralFeature)eReference);
                if (object == null) continue;
                if (eReference.isMany()) {
                    Collection collection = (Collection)object;
                    set.removeAll(collection);
                    continue;
                }
                set.remove(object);
            }
        }
    }

    protected Iterable<EReference> getIncludedReferences(EClass eClass) {
        return Iterables.filter((Iterable)eClass.getEAllReferences(), this::isIncluded);
    }

    protected boolean useEquals() {
        return false;
    }

    protected boolean useIsSet() {
        return false;
    }

    <K, V> Map<K, V> a() {
        return this.useEquals() ? new HashMap() : new IdentityHashMap();
    }

    List<EReference> a(EClass eClass) {
        return this.a.computeIfAbsent(eClass, eClass2 -> {
            ArrayList arrayList = Lists.newArrayList(this.getIncludedReferences(eClass));
            return arrayList.isEmpty() ? Collections.emptyList() : arrayList;
        });
    }

    Object a(EObject eObject, EStructuralFeature eStructuralFeature) {
        if (!this.useIsSet() || eObject.eIsSet(eStructuralFeature)) {
            return eObject.eGet(eStructuralFeature);
        }
        return null;
    }

    void a(Collection<EObject> collection) {
        for (EObject eObject : collection) {
            this.a(eObject);
        }
    }

    void a(EObject eObject) {
        if (this.targets.contains(eObject)) {
            this.affectedObjects.add(eObject);
        }
    }

    static boolean a(Notification notification) {
        int n;
        int n2;
        Object object = notification.getNotifier();
        return object instanceof Resource ? (n2 = notification.getFeatureID(Resource.class)) == 2 : object instanceof ResourceSet && (n = notification.getFeatureID(ResourceSet.class)) == 0;
    }
}

