/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.transaction;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.validation.model.IConstraintStatus;

public class Transactions {
    public static String OPTION_SUPPRESS_ALERT = "suppress_alert";

    public static <V> V runExclusive(TransactionalEditingDomain transactionalEditingDomain, Callable<V> callable) throws InterruptedException, ExecutionException {
        a<V> a2 = new a<V>(callable);
        transactionalEditingDomain.runExclusive(a2);
        return ((FutureTask)a2).get();
    }

    public static <V> Future<V> safeRunExclusive(TransactionalEditingDomain transactionalEditingDomain, Callable<V> callable) throws InterruptedException {
        return Transactions.a(transactionalEditingDomain, new a<V>(callable));
    }

    public static Future<Object> safeRunExclusive(TransactionalEditingDomain transactionalEditingDomain, Runnable runnable) throws InterruptedException {
        return Transactions.a(transactionalEditingDomain, new a<Object>(runnable, null));
    }

    static <V> Future<V> a(TransactionalEditingDomain transactionalEditingDomain, FutureTask<V> futureTask) throws InterruptedException {
        if (transactionalEditingDomain != null && transactionalEditingDomain.getCommandStack() != null) {
            transactionalEditingDomain.runExclusive(futureTask);
            return futureTask;
        }
        futureTask.cancel(false);
        return futureTask;
    }

    public static <V> V runWritable(TransactionalEditingDomain transactionalEditingDomain, Callable<V> callable) throws RollbackException, InterruptedException, ExecutionException {
        return Transactions.runWritable(transactionalEditingDomain, callable, Collections.emptyMap());
    }

    public static <V> V runWritable(TransactionalEditingDomain transactionalEditingDomain, Callable<V> callable, Map<Object, Object> map) throws RollbackException, InterruptedException, ExecutionException {
        return Transactions.a(transactionalEditingDomain, new a<V>(callable), map).get();
    }

    public static void runWritable(TransactionalEditingDomain transactionalEditingDomain, Runnable runnable) throws RollbackException, InterruptedException, ExecutionException {
        Transactions.runWritable(transactionalEditingDomain, runnable, Collections.emptyMap());
    }

    public static void runWritable(TransactionalEditingDomain transactionalEditingDomain, Runnable runnable, Map<Object, Object> map) throws RollbackException, InterruptedException, ExecutionException {
        Transactions.a(transactionalEditingDomain, new a<Object>(runnable, null), map).get();
    }

    static <V> Future<V> a(TransactionalEditingDomain transactionalEditingDomain, FutureTask<V> futureTask, Map<Object, Object> map) throws InterruptedException, RollbackException {
        CommandStack commandStack = transactionalEditingDomain.getCommandStack();
        ((TransactionalCommandStack)commandStack).execute((Command)new net.astah.emf.common.transaction.a(transactionalEditingDomain, futureTask), map);
        return futureTask;
    }

    public static boolean isWritable(TransactionalEditingDomain transactionalEditingDomain) {
        InternalTransaction internalTransaction = ((InternalTransactionalEditingDomain)transactionalEditingDomain).getActiveTransaction();
        return internalTransaction == null || !internalTransaction.isReadOnly();
    }

    public static boolean isConstraintViolation(RollbackException rollbackException) {
        return Transactions.isConstraintViolation(rollbackException.getStatus());
    }

    public static boolean isConstraintViolation(IStatus iStatus) {
        if (iStatus instanceof IConstraintStatus) {
            return true;
        }
        if (iStatus.isMultiStatus()) {
            for (IStatus iStatus2 : iStatus.getChildren()) {
                if (!Transactions.isConstraintViolation(iStatus2)) continue;
                return true;
            }
        }
        return false;
    }

    static class a<V>
    extends FutureTask<V> {
        public a(Callable<V> callable) {
            super(callable);
        }

        public a(Runnable runnable, V v) {
            super(runnable, v);
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            try {
                return super.get();
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw executionException;
            }
        }

        @Override
        public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return super.get(l, timeUnit);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw executionException;
            }
        }
    }
}

