/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.resource;

import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import net.astah.emf.common.ecore.EcoreCopier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class Resources {
    public static boolean isLoading(Resource resource) {
        return resource instanceof ResourceImpl && ((ResourceImpl)resource).isLoading();
    }

    public static String getXMINamespace(Resource resource) {
        String string;
        if (resource instanceof XMIResource && (string = ((XMIResource)resource).getXMINamespace()) != null) {
            return string;
        }
        if (resource instanceof XMLResource) {
            return "http://www.omg.org/XMI";
        }
        return null;
    }

    public static void copy(Resource resource, Resource resource2) {
        Resources.copy(resource, resource2, new EcoreCopier());
    }

    public static void copy(Resource resource, Resource resource2, EcoreUtil.Copier copier) {
        resource2.getContents().addAll(copier.copyAll((Collection)resource.getContents()));
        copier.copyReferences();
        if (resource instanceof XMLResource && resource2 instanceof XMLResource) {
            XMLResource xMLResource = (XMLResource)resource;
            XMLResource xMLResource2 = (XMLResource)resource2;
            copier.forEach((eObject, eObject2) -> {
                String string = xMLResource.getID(eObject);
                if (string != null) {
                    xMLResource2.setID(eObject2, string);
                }
            });
        }
    }

    public static void replaceFactories(Resource.Factory.Registry registry, Class<? extends Resource.Factory> clazz, Object object) {
        Resources.replaceFactories(registry, clazz::isInstance, object);
    }

    public static void replaceFactories(Resource.Factory.Registry registry, Predicate<Object> predicate, Object object) {
        for (Map.Entry entry : registry.getProtocolToFactoryMap().entrySet()) {
            if (!predicate.test(entry.getValue())) continue;
            entry.setValue(object);
        }
        for (Map.Entry entry : registry.getExtensionToFactoryMap().entrySet()) {
            if (!predicate.test(entry.getValue())) continue;
            entry.setValue(object);
        }
        for (Map.Entry entry : registry.getContentTypeToFactoryMap().entrySet()) {
            if (!predicate.test(entry.getValue())) continue;
            entry.setValue(object);
        }
    }

    public static Monitor getMonitor(Map<?, ?> map, String string) {
        if (map != null) {
            Object obj = map.get(string);
            if (obj instanceof IProgressMonitor) {
                return BasicMonitor.toMonitor((IProgressMonitor)((IProgressMonitor)obj));
            }
            if (obj instanceof Monitor) {
                return (Monitor)obj;
            }
        }
        return null;
    }

    public static IProgressMonitor getProgressMonitor(Map<?, ?> map, String string) {
        if (map != null) {
            Object obj = map.get(string);
            if (obj instanceof IProgressMonitor) {
                return (IProgressMonitor)obj;
            }
            if (obj instanceof Monitor) {
                return BasicMonitor.toIProgressMonitor((Monitor)((Monitor)obj));
            }
        }
        return null;
    }

    public static SubMonitor getSubMonitor(Map<?, ?> map, String string) {
        return SubMonitor.convert((IProgressMonitor)Resources.getProgressMonitor(map, string));
    }
}

